/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.mediastorage;

import com.aventstack.extentreports.mediastorage.MediaStorage;
import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

class LocalMediaManager
implements MediaStorage {
    private static final Logger logger = Logger.getLogger(LocalMediaManager.class.getName());
    private String reporterGeneratedFilePath;
    private String targetPath;
    private String relativePath;

    LocalMediaManager() {
    }

    @Override
    public void init(String reporterGeneratedFilePath) {
        this.reporterGeneratedFilePath = reporterGeneratedFilePath;
        this.mkDirs();
    }

    @Override
    public void storeMedia(Media screenCapture) throws IOException {
        this.storeMediaFileLocal(screenCapture);
    }

    private void mkDirs() {
        String fileName = FileUtil.getFileNameWithoutExtension(this.reporterGeneratedFilePath) + ".";
        String absolutePath = new File(this.reporterGeneratedFilePath).getAbsolutePath().replace("\\", "/");
        String basePath = new File(absolutePath).getParent().replace("\\", "/");
        this.mkDirs(basePath, fileName, 0);
    }

    private void mkDirs(String basePath, String fileName, int cnt) {
        this.relativePath = fileName + cnt + "/";
        this.targetPath = basePath + "/" + this.relativePath;
        File f = new File(this.targetPath);
        if (!f.exists()) {
            f.mkdirs();
        } else {
            this.mkDirs(basePath, fileName, ++cnt);
        }
    }

    private void storeMediaFileLocal(Media sc) throws IOException {
        String baseFileName;
        File f = new File(sc.getPath());
        if (!f.exists()) {
            logger.warning("Unable to locate media file: " + sc.getPath());
            return;
        }
        String mediaFileName = baseFileName = new File(sc.getPath()).getName();
        String copyToPath = this.targetPath + baseFileName;
        File copyToFile = new File(copyToPath);
        int cnt = 0;
        while (copyToFile.exists()) {
            String name = FileUtil.getFileNameWithoutExtension(baseFileName) + "." + cnt;
            String ext = FileUtil.getExtension(baseFileName);
            mediaFileName = name + "." + ext;
            copyToPath = this.targetPath + mediaFileName + "/";
            copyToFile = new File(copyToPath);
            ++cnt;
        }
        Path p = Paths.get(copyToPath, new String[0]);
        Files.copy(new FileInputStream(f), p, new CopyOption[0]);
        sc.setPath(this.relativePath + mediaFileName);
    }
}

