/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.ExceptionTestContextImpl;
import com.aventstack.extentreports.ExtentReporter;
import com.aventstack.extentreports.IReport;
import com.aventstack.extentreports.SessionStatusStats;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.SystemAttributeContext;
import com.aventstack.extentreports.TestAttributeTestContextProvider;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.SystemAttribute;
import com.aventstack.extentreports.model.Test;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;

abstract class Report
implements IReport,
Serializable {
    private static final long serialVersionUID = -6302628790953442220L;
    private Status reportStatus = Status.UNKNOWN;
    private TestAttributeTestContextProvider<Category> testAttrCategoryContext;
    private TestAttributeTestContextProvider<Author> testAttrAuthorContext;
    private ExceptionTestContextImpl exContextBuilder;
    private SessionStatusStats stats;
    private SystemAttributeContext saContext = new SystemAttributeContext();
    private List<ExtentReporter> reporterList;
    private List<String> testRunnerLogs;
    private List<Test> testList;

    protected Report() {
    }

    protected void attach(ExtentReporter reporter) {
        if (this.reporterList == null) {
            this.reporterList = new ArrayList<ExtentReporter>();
        }
        this.reporterList.add(reporter);
        reporter.start();
    }

    protected void detach(ExtentReporter reporter) {
        reporter.stop();
        this.reporterList.remove(reporter);
    }

    protected synchronized void createTest(Test test) {
        if (this.testList == null) {
            this.testList = new ArrayList<Test>();
        }
        this.testList.add(test);
        this.reporterList.forEach(x -> x.onTestStarted(test));
    }

    synchronized void addNode(Test node) {
        this.reporterList.forEach(x -> x.onNodeStarted(node));
    }

    synchronized void addLog(Test test, Log log) {
        this.collectRunInfo();
        this.reporterList.forEach(x -> x.onLogAdded(test, log));
    }

    synchronized void assignCategory(Test test, Category category) {
        this.reporterList.forEach(x -> x.onCategoryAssigned(test, category));
    }

    synchronized void assignAuthor(Test test, Author author) {
        this.reporterList.forEach(x -> x.onAuthorAssigned(test, author));
    }

    synchronized void addScreenCapture(Test test, ScreenCapture sc) throws IOException {
        this.reporterList.forEach(x -> {
            try {
                x.onScreenCaptureAdded(test, sc);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    void setNodeAttributes(Test node) {
        if (node.hasCategory()) {
            node.getCategoryList().forEach(x -> this.testAttrCategoryContext.setAttributeContext((Category)x, node));
        }
        if (node.hasAuthor()) {
            node.getAuthorList().forEach(x -> this.testAttrAuthorContext.setAttributeContext((Author)x, node));
        }
        if (node.hasChildren()) {
            node.getNodeContext().getAll().forEach(this::setNodeAttributes);
        }
    }

    void setNodeExceptionInfo(Test node) {
        if (node.hasException()) {
            node.getExceptionInfoList().forEach(x -> this.exContextBuilder.setExceptionContext((ExceptionInfo)x, node));
        }
    }

    protected TestAttributeTestContextProvider<Author> getAuthorContextInfo() {
        return this.testAttrAuthorContext;
    }

    private void updateReportStatus(Status logStatus) {
        int reportStatusIndex;
        int logStatusIndex = Status.getStatusHierarchy().indexOf(logStatus);
        this.reportStatus = logStatusIndex < (reportStatusIndex = Status.getStatusHierarchy().indexOf(this.reportStatus)) ? logStatus : this.reportStatus;
    }

    private void endTest(Test test) {
        test.end();
        this.updateReportStatus(test.getStatus());
    }

    protected synchronized void flush() {
        this.collectRunInfo();
        this.notifyReporters();
    }

    private synchronized void collectRunInfo() {
        if (this.testList == null || this.testList.isEmpty()) {
            return;
        }
        this.testList.forEach(this::endTest);
        this.stats = new SessionStatusStats(this.testList);
        this.testAttrCategoryContext = new TestAttributeTestContextProvider();
        this.testAttrAuthorContext = new TestAttributeTestContextProvider();
        this.exContextBuilder = new ExceptionTestContextImpl();
        this.testList.forEach(test -> {
            if (test.hasCategory()) {
                test.getCategoryList().forEach(x -> this.testAttrCategoryContext.setAttributeContext((Category)x, (Test)test));
            }
            if (test.hasAuthor()) {
                test.getAuthorList().forEach(x -> this.testAttrAuthorContext.setAttributeContext((Author)x, (Test)test));
            }
            if (test.hasException()) {
                test.getExceptionInfoList().forEach(x -> this.exContextBuilder.setExceptionContext((ExceptionInfo)x, (Test)test));
            }
            if (test.hasChildren()) {
                test.getNodeContext().getAll().forEach(x -> {
                    this.setNodeAttributes((Test)x);
                    this.setNodeExceptionInfo((Test)x);
                });
            }
        });
    }

    private synchronized void notifyReporters() {
        this.reporterList.forEach(x -> {
            x.setTestList(this.testList);
            x.setCategoryContextInfo(this.testAttrCategoryContext);
            x.setExceptionContextInfo(this.exContextBuilder);
            x.setSystemAttributeContext(this.saContext);
            x.setTestRunnerLogs(this.testRunnerLogs);
            x.setStatusCount(this.stats);
        });
        this.reporterList.forEach(ExtentReporter::flush);
    }

    protected void end() {
        this.flush();
        this.reporterList.forEach(ExtentReporter::stop);
        this.reporterList.clear();
    }

    protected void setSystemInfo(SystemAttribute sa) {
        this.saContext.setSystemAttribute(sa);
    }

    protected void setTestRunnerLogs(String log) {
        if (this.testRunnerLogs == null) {
            this.testRunnerLogs = new ArrayList<String>();
        }
        this.testRunnerLogs.add(log);
    }
}

