/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.GherkinKeyword;
import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.gherkin.model.IGherkinFormatterModel;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.model.Author;
import com.aventstack.extentreports.model.Category;
import com.aventstack.extentreports.model.ExceptionInfo;
import com.aventstack.extentreports.model.IAddsMedia;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.MediaType;
import com.aventstack.extentreports.model.ScreenCapture;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.utils.ExceptionUtil;
import java.io.IOException;
import java.io.Serializable;

public class ExtentTest
implements IAddsMedia,
Serializable {
    private static final long serialVersionUID = 9199820968410788862L;
    private ExtentReports extent;
    private Test test;

    ExtentTest(ExtentReports extent, Class<? extends IGherkinFormatterModel> type, String testName, String description) {
        if (testName == null || testName.isEmpty()) {
            throw new IllegalArgumentException("testName cannot be null or empty");
        }
        this.extent = extent;
        this.test = new Test();
        this.test.setName(testName.trim());
        this.test.setDescription(description == null ? "" : description.trim());
        if (type != null) {
            this.test.setBehaviorDrivenType(type);
        }
    }

    ExtentTest(ExtentReports extent, String testName, String description) {
        this(extent, null, testName, description);
    }

    public synchronized ExtentTest createNode(String name, String description) {
        ExtentTest t = new ExtentTest(this.extent, name, description);
        t.getModel().setLevel(this.test.getLevel() + 1);
        t.getModel().setParent(this.getModel());
        this.test.getNodeContext().add(t.getModel());
        this.extent.addNode(t.getModel());
        return t;
    }

    public synchronized ExtentTest createNode(Class<? extends IGherkinFormatterModel> type, String name, String description) {
        ExtentTest t = this.createNode(name, description);
        t.getModel().setBehaviorDrivenType(type);
        return t;
    }

    public synchronized ExtentTest createNode(Class<? extends IGherkinFormatterModel> type, String name) {
        return this.createNode(type, name, null);
    }

    public synchronized ExtentTest createNode(GherkinKeyword gherkinKeyword, String name, String description) {
        return this.createNode(gherkinKeyword.getKeyword().getClass(), name, description);
    }

    public synchronized ExtentTest createNode(GherkinKeyword gherkinKeyword, String name) {
        return this.createNode(gherkinKeyword.getKeyword().getClass(), name, null);
    }

    public synchronized ExtentTest createNode(String name) {
        return this.createNode(name, null);
    }

    public synchronized ExtentTest log(Status status, String details) {
        Log evt = this.createLog(status, details);
        return this.addLog(evt);
    }

    public synchronized ExtentTest log(Status status, Markup markup) {
        String details = markup.getMarkup();
        return this.log(status, details);
    }

    private synchronized ExtentTest addLog(Log evt) {
        this.test.getLogContext().add(evt);
        this.test.end();
        this.extent.addLog(this.test, evt);
        return this;
    }

    private Log createLog(Status status) {
        Log evt = new Log();
        evt.setStatus(status);
        evt.setSequence(this.test.getLogContext().getAll().size() + 1);
        return evt;
    }

    private Log createLog(Status status, String details) {
        Log evt = this.createLog(status);
        evt.setDetails(details == null ? "" : details.trim());
        return evt;
    }

    public synchronized ExtentTest log(Status logStatus, Throwable t) {
        ExceptionInfo exInfo = new ExceptionInfo();
        exInfo.setException(t);
        exInfo.setExceptionName(ExceptionUtil.getExceptionHeadline(t));
        exInfo.setStackTrace(ExceptionUtil.getStackTrace(t));
        this.getModel().setExceptionInfo(exInfo);
        if (this.getModel().getLevel() > 1) {
            this.getModel().getParent().setExceptionInfo(exInfo);
        }
        this.log(logStatus, exInfo.getStackTrace());
        return this;
    }

    public ExtentTest info(String details) {
        this.log(Status.INFO, details);
        return this;
    }

    public ExtentTest info(Throwable t) {
        this.log(Status.INFO, t);
        return this;
    }

    public ExtentTest info(Markup m) {
        this.log(Status.INFO, m);
        return this;
    }

    public ExtentTest pass(String details) {
        this.log(Status.PASS, details);
        return this;
    }

    public ExtentTest pass(Throwable t) {
        this.log(Status.PASS, t);
        return this;
    }

    public ExtentTest pass(Markup m) {
        this.log(Status.PASS, m);
        return this;
    }

    public ExtentTest fail(String details) {
        this.log(Status.FAIL, details);
        return this;
    }

    public ExtentTest fail(Throwable t) {
        this.log(Status.FAIL, t);
        return this;
    }

    public ExtentTest fail(Markup m) {
        this.log(Status.FAIL, m);
        return this;
    }

    public ExtentTest fatal(String details) {
        this.log(Status.FATAL, details);
        return this;
    }

    public ExtentTest fatal(Throwable t) {
        this.log(Status.FATAL, t);
        return this;
    }

    public ExtentTest fatal(Markup m) {
        this.log(Status.FATAL, m);
        return this;
    }

    public ExtentTest warning(String details) {
        this.log(Status.WARNING, details);
        return this;
    }

    public ExtentTest warning(Throwable t) {
        this.log(Status.WARNING, t);
        return this;
    }

    public ExtentTest warning(Markup m) {
        this.log(Status.WARNING, m);
        return this;
    }

    public ExtentTest error(String details) {
        this.log(Status.ERROR, details);
        return this;
    }

    public ExtentTest error(Throwable t) {
        this.log(Status.ERROR, t);
        return this;
    }

    public ExtentTest error(Markup m) {
        this.log(Status.ERROR, m);
        return this;
    }

    public ExtentTest skip(String details) {
        this.log(Status.SKIP, details);
        return this;
    }

    public ExtentTest skip(Throwable t) {
        this.log(Status.SKIP, t);
        return this;
    }

    public ExtentTest skip(Markup m) {
        this.log(Status.SKIP, m);
        return this;
    }

    public ExtentTest assignCategory(String category) {
        String cat = category.replace(" ", "");
        Category c = new Category();
        c.setName(cat);
        this.test.setCategory(c);
        this.extent.assignCategory(this.test, c);
        return this;
    }

    public ExtentTest assignAuthor(String author) {
        Author a = new Author();
        a.setName(author);
        this.test.setAuthor(a);
        this.extent.assignAuthor(this.test, a);
        return this;
    }

    @Override
    public ExtentTest addScreenCaptureFromPath(String imagePath, String title) throws IOException {
        ScreenCapture sc = new ScreenCapture();
        sc.setPath(imagePath);
        sc.setName(title);
        sc.setMediaType(MediaType.IMG);
        this.test.setScreenCapture(sc);
        if (this.test.getObjectId() != null) {
            int sequence = this.test.getScreenCaptureList().size();
            sc.setTestObjectId(this.test.getObjectId());
            sc.setSequence(sequence);
        }
        this.extent.addScreenCapture(this.test, sc);
        return this;
    }

    @Override
    public ExtentTest addScreenCaptureFromPath(String imagePath) throws IOException {
        return this.addScreenCaptureFromPath(imagePath, null);
    }

    public Status getStatus() {
        return this.getModel().getStatus();
    }

    public Test getModel() {
        return this.test;
    }
}

