/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static final Logger log = LoggerFactory.getLogger(IOUtil.class);

    public static void copyClassPathResource(Class<?> clazz, String resourcePath, String copyToPath) {
        try {
            InputStream in = clazz.getResourceAsStream(resourcePath);
            if (null == in) {
                throw new IllegalArgumentException("Unable to find resource " + resourcePath);
            }
            FileOutputStream out = new FileOutputStream(copyToPath);
            byte[] b = new byte[1024];
            int noOfBytes = 0;
            while ((noOfBytes = in.read(b)) != -1) {
                out.write(b, 0, noOfBytes);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException e) {
            log.error("Resource file {} was not found", (Object)resourcePath, (Object)e);
        }
        catch (Exception e) {
            log.error("An exception occurred while moving resource {} to {}", new Object[]{resourcePath, copyToPath, e});
        }
    }
}

