/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMappedBodyHandler<T>
implements HttpResponse.BodyHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(JsonMappedBodyHandler.class);
    private final Class<T> _clazz;
    private final ObjectMapper _objectMapper;

    public JsonMappedBodyHandler(Class<T> clazz, ObjectMapper objectMapper) {
        this._clazz = clazz;
        this._objectMapper = objectMapper;
    }

    @Override
    public HttpResponse.BodySubscriber<T> apply(HttpResponse.ResponseInfo responseInfo) {
        HttpResponse.BodySubscriber<String> bodySubscriber = HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8);
        return HttpResponse.BodySubscribers.mapping(bodySubscriber, body -> {
            log.debug("Received response from service: {}", body);
            if (body.contains("\"error\":") && body.contains("\"status\":")) {
                log.error("Service returned ErrorResponse: {}", body);
            }
            try {
                return this._objectMapper.readValue(body, this._clazz);
            }
            catch (JsonProcessingException e) {
                log.error("Failed to map expected response of type {}. Received response: {}", new Object[]{this._clazz.getSimpleName(), body, e});
                throw new UncheckedIOException((IOException)((Object)e));
            }
        });
    }
}

