/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Embed {
    private static final Logger log = LoggerFactory.getLogger(Embed.class);
    public static final List<String> SUPPORTED_MEDIA_TYPES = List.of("image/png", "image/jpg", "image/jpeg", "image/gif", "image/bmp", "image/webp", "image/tiff");
    private final UUID uuid = UUID.randomUUID();
    private String url;
    private String base64;
    private File file;
    private byte[] bytes;
    private String mediaType;
    private boolean store = true;

    public Embed(String base64, String mediaType) {
        this.base64 = base64;
        this.mediaType = mediaType;
    }

    public Embed(File file, String mediaType) {
        this.file = file;
        this.mediaType = mediaType;
    }

    public Embed(byte[] bytes, String mediaType) {
        this.bytes = bytes;
        this.mediaType = mediaType;
    }

    public void save(File filePath) throws IOException {
        if (!SUPPORTED_MEDIA_TYPES.contains(this.mediaType)) {
            log.debug("Unknown mediaType {}, skipping save", (Object)this.mediaType);
            return;
        }
        if (null != this.bytes) {
            Files.write(filePath.toPath(), this.bytes, new OpenOption[0]);
        } else if (null != this.base64 && !this.base64.isBlank()) {
            byte[] data = Base64.getDecoder().decode(this.base64.getBytes());
            Files.write(filePath.toPath(), data, new OpenOption[0]);
        } else if (null != this.file) {
            Files.copy(this.file.toPath(), filePath.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else {
            log.error("Unable to save Embed to {}. Source missing", (Object)filePath.getPath());
        }
    }

    public File makePath(File parentDir) {
        return new File(parentDir, this.getName());
    }

    public String getName() {
        String ext = this.mediaType.split("/")[1];
        return String.valueOf(this.uuid) + "." + ext;
    }

    public String id() {
        return this.uuid.toString();
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getBase64() {
        return this.base64;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public byte[] getBytes() {
        return this.bytes;
    }

    @Generated
    public String getMediaType() {
        return this.mediaType;
    }

    @Generated
    public boolean isStore() {
        return this.store;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setBase64(String base64) {
        this.base64 = base64;
    }

    @Generated
    public void setFile(File file) {
        this.file = file;
    }

    @Generated
    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Generated
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Generated
    public void setStore(boolean store) {
        this.store = store;
    }

    @Generated
    public Embed() {
    }
}

