/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.api;

import com.autocheckinsurance.sdk.ApiCallback;
import com.autocheckinsurance.sdk.ApiClient;
import com.autocheckinsurance.sdk.ApiException;
import com.autocheckinsurance.sdk.ApiResponse;
import com.autocheckinsurance.sdk.Configuration;
import com.autocheckinsurance.sdk.Pair;
import com.autocheckinsurance.sdk.ProgressRequestBody;
import com.autocheckinsurance.sdk.ProgressResponseBody;
import com.autocheckinsurance.sdk.model.HistoryRequest;
import com.autocheckinsurance.sdk.model.HistoryResponse;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class VehicleHistoryApi {
    private ApiClient apiClient;

    public VehicleHistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VehicleHistoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call historyDiscrepancyCall(String xApiKey, String xAutotecId, HistoryRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        HistoryRequest localVarPostBody = request;
        String localVarPath = "/vehicle/history/discrepancy";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (xAutotecId != null) {
            localVarHeaderParams.put("x-autotec-id", this.apiClient.parameterToString(xAutotecId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"CustomerAuthorizer", "api_key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call historyDiscrepancyValidateBeforeCall(String xApiKey, String xAutotecId, HistoryRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling historyDiscrepancy(Async)");
        }
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling historyDiscrepancy(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling historyDiscrepancy(Async)");
        }
        Call call = this.historyDiscrepancyCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;
    }

    public HistoryResponse historyDiscrepancy(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        ApiResponse<HistoryResponse> resp = this.historyDiscrepancyWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    public ApiResponse<HistoryResponse> historyDiscrepancyWithHttpInfo(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        Call call = this.historyDiscrepancyValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call historyDiscrepancyAsync(String xApiKey, String xAutotecId, HistoryRequest request, final ApiCallback<HistoryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.historyDiscrepancyValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call historyFullCall(String xApiKey, String xAutotecId, HistoryRequest request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        HistoryRequest localVarPostBody = request;
        String localVarPath = "/vehicle/history/full";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (xApiKey != null) {
            localVarHeaderParams.put("x-api-key", this.apiClient.parameterToString(xApiKey));
        }
        if (xAutotecId != null) {
            localVarHeaderParams.put("x-autotec-id", this.apiClient.parameterToString(xAutotecId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"CustomerAuthorizer", "api_key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call historyFullValidateBeforeCall(String xApiKey, String xAutotecId, HistoryRequest request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling historyFull(Async)");
        }
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling historyFull(Async)");
        }
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling historyFull(Async)");
        }
        Call call = this.historyFullCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;
    }

    public HistoryResponse historyFull(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        ApiResponse<HistoryResponse> resp = this.historyFullWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    public ApiResponse<HistoryResponse> historyFullWithHttpInfo(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        Call call = this.historyFullValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call historyFullAsync(String xApiKey, String xAutotecId, HistoryRequest request, final ApiCallback<HistoryResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.historyFullValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

