/*
 * ACI Services API
 * API for methods pertaining to all ACI services
 *
 * OpenAPI spec version: 2.0.7
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.autocheckinsurance.sdk.api;

import com.autocheckinsurance.sdk.ApiCallback;
import com.autocheckinsurance.sdk.ApiClient;
import com.autocheckinsurance.sdk.ApiException;
import com.autocheckinsurance.sdk.ApiResponse;
import com.autocheckinsurance.sdk.Configuration;
import com.autocheckinsurance.sdk.Pair;
import com.autocheckinsurance.sdk.ProgressRequestBody;
import com.autocheckinsurance.sdk.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.autocheckinsurance.sdk.model.HistoryRequest;
import com.autocheckinsurance.sdk.model.HistoryResponse;

import java.lang.reflect.Type;

public class VehicleHistoryApi {
    private ApiClient apiClient;

    public VehicleHistoryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VehicleHistoryApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for historyDiscrepancy
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call historyDiscrepancyCall(String xApiKey, String xAutotecId, HistoryRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/vehicle/history/discrepancy";

        java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
        java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();

        java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
        if (xApiKey != null)
        localVarHeaderParams.put("x-api-key", apiClient.parameterToString(xApiKey));
        if (xAutotecId != null)
        localVarHeaderParams.put("x-autotec-id", apiClient.parameterToString(xAutotecId));

        java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "CustomerAuthorizer", "api_key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call historyDiscrepancyValidateBeforeCall(String xApiKey, String xAutotecId, HistoryRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'xApiKey' is set
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling historyDiscrepancy(Async)");
        }
        
        // verify the required parameter 'xAutotecId' is set
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling historyDiscrepancy(Async)");
        }
        
        // verify the required parameter 'request' is set
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling historyDiscrepancy(Async)");
        }
        

        com.squareup.okhttp.Call call = historyDiscrepancyCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Retrieve Odometer Discrepancy Activity for Requested Vehicles
     * Method to retrieve odometer discrepancy history for a list of vehicles.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @return HistoryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public HistoryResponse historyDiscrepancy(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        ApiResponse<HistoryResponse> resp = historyDiscrepancyWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    /**
     * Retrieve Odometer Discrepancy Activity for Requested Vehicles
     * Method to retrieve odometer discrepancy history for a list of vehicles.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @return ApiResponse&lt;HistoryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<HistoryResponse> historyDiscrepancyWithHttpInfo(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        com.squareup.okhttp.Call call = historyDiscrepancyValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve Odometer Discrepancy Activity for Requested Vehicles (asynchronously)
     * Method to retrieve odometer discrepancy history for a list of vehicles.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call historyDiscrepancyAsync(String xApiKey, String xAutotecId, HistoryRequest request, final ApiCallback<HistoryResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = historyDiscrepancyValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for historyFull
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call historyFullCall(String xApiKey, String xAutotecId, HistoryRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/vehicle/history/full";

        java.util.List<Pair> localVarQueryParams = new java.util.ArrayList<Pair>();
        java.util.List<Pair> localVarCollectionQueryParams = new java.util.ArrayList<Pair>();

        java.util.Map<String, String> localVarHeaderParams = new java.util.HashMap<String, String>();
        if (xApiKey != null)
        localVarHeaderParams.put("x-api-key", apiClient.parameterToString(xApiKey));
        if (xAutotecId != null)
        localVarHeaderParams.put("x-autotec-id", apiClient.parameterToString(xAutotecId));

        java.util.Map<String, Object> localVarFormParams = new java.util.HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "CustomerAuthorizer", "api_key" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call historyFullValidateBeforeCall(String xApiKey, String xAutotecId, HistoryRequest request, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'xApiKey' is set
        if (xApiKey == null) {
            throw new ApiException("Missing the required parameter 'xApiKey' when calling historyFull(Async)");
        }
        
        // verify the required parameter 'xAutotecId' is set
        if (xAutotecId == null) {
            throw new ApiException("Missing the required parameter 'xAutotecId' when calling historyFull(Async)");
        }
        
        // verify the required parameter 'request' is set
        if (request == null) {
            throw new ApiException("Missing the required parameter 'request' when calling historyFull(Async)");
        }
        

        com.squareup.okhttp.Call call = historyFullCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Retrieve Historical Activity for Requested Vehicles
     * Method to retrieve vehicle history and ownership data (if authorized) for a list of vehicles.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @return HistoryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public HistoryResponse historyFull(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        ApiResponse<HistoryResponse> resp = historyFullWithHttpInfo(xApiKey, xAutotecId, request);
        return resp.getData();
    }

    /**
     * Retrieve Historical Activity for Requested Vehicles
     * Method to retrieve vehicle history and ownership data (if authorized) for a list of vehicles.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @return ApiResponse&lt;HistoryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<HistoryResponse> historyFullWithHttpInfo(String xApiKey, String xAutotecId, HistoryRequest request) throws ApiException {
        com.squareup.okhttp.Call call = historyFullValidateBeforeCall(xApiKey, xAutotecId, request, null, null);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Retrieve Historical Activity for Requested Vehicles (asynchronously)
     * Method to retrieve vehicle history and ownership data (if authorized) for a list of vehicles.
     * @param xApiKey the AutoTec assigned authentication credential for the calling customer (required)
     * @param xAutotecId the AutoTec assigned identification id for the calling customer (required)
     * @param request The vehicle history request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call historyFullAsync(String xApiKey, String xAutotecId, HistoryRequest request, final ApiCallback<HistoryResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = historyFullValidateBeforeCall(xApiKey, xAutotecId, request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
