/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="recall information for the vehicle")
public class RecallRecord {
    @SerializedName(value="consequence")
    private Boolean consequence = null;
    @SerializedName(value="date")
    private LocalDate date = null;
    @SerializedName(value="nhtsaCampaignNumber")
    private String nhtsaCampaignNumber = null;
    @SerializedName(value="remedy")
    private String remedy = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="summary")
    private String summary = null;
    @SerializedName(value="title")
    private String title = null;

    public RecallRecord consequence(Boolean consequence) {
        this.consequence = consequence;
        return this;
    }

    @ApiModelProperty(value="the consequence of the recall")
    public Boolean isConsequence() {
        return this.consequence;
    }

    public void setConsequence(Boolean consequence) {
        this.consequence = consequence;
    }

    public RecallRecord date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="the date of the recall")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public RecallRecord nhtsaCampaignNumber(String nhtsaCampaignNumber) {
        this.nhtsaCampaignNumber = nhtsaCampaignNumber;
        return this;
    }

    @ApiModelProperty(value="the NHTSA compaign number")
    public String getNhtsaCampaignNumber() {
        return this.nhtsaCampaignNumber;
    }

    public void setNhtsaCampaignNumber(String nhtsaCampaignNumber) {
        this.nhtsaCampaignNumber = nhtsaCampaignNumber;
    }

    public RecallRecord remedy(String remedy) {
        this.remedy = remedy;
        return this;
    }

    @ApiModelProperty(value="the remedy for the recall")
    public String getRemedy() {
        return this.remedy;
    }

    public void setRemedy(String remedy) {
        this.remedy = remedy;
    }

    public RecallRecord status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="the status of the recall")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public RecallRecord summary(String summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(value="the recall summary")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public RecallRecord title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="the recall title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecallRecord recallRecord = (RecallRecord)o;
        return Objects.equals(this.consequence, recallRecord.consequence) && Objects.equals(this.date, recallRecord.date) && Objects.equals(this.nhtsaCampaignNumber, recallRecord.nhtsaCampaignNumber) && Objects.equals(this.remedy, recallRecord.remedy) && Objects.equals(this.status, recallRecord.status) && Objects.equals(this.summary, recallRecord.summary) && Objects.equals(this.title, recallRecord.title);
    }

    public int hashCode() {
        return Objects.hash(this.consequence, this.date, this.nhtsaCampaignNumber, this.remedy, this.status, this.summary, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecallRecord {\n");
        sb.append("    consequence: ").append(this.toIndentedString(this.consequence)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    nhtsaCampaignNumber: ").append(this.toIndentedString(this.nhtsaCampaignNumber)).append("\n");
        sb.append("    remedy: ").append(this.toIndentedString(this.remedy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

