/*
 * Decompiled with CFR 0.152.
 */
package com.autocheckinsurance.sdk.model;

import com.autocheckinsurance.sdk.model.HistoryRecord;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="the historical information for a vehicle")
public class VehicleHistory {
    @SerializedName(value="accidentCount")
    private Integer accidentCount = null;
    @SerializedName(value="assured")
    private Boolean assured = null;
    @SerializedName(value="bbp")
    private BbpEnum bbp = null;
    @SerializedName(value="conditionRpt")
    private Boolean conditionRpt = null;
    @SerializedName(value="count")
    private Integer count = null;
    @SerializedName(value="estimatedAverageMiles")
    private Integer estimatedAverageMiles = null;
    @SerializedName(value="historyRecords")
    private List<HistoryRecord> historyRecords = null;
    @SerializedName(value="lastOdometer")
    private Integer lastOdometer = null;
    @SerializedName(value="mixedOdometer")
    private Boolean mixedOdometer = null;
    @SerializedName(value="odometer")
    private Boolean odometer = null;
    @SerializedName(value="recallCount")
    private Integer recallCount = null;
    @SerializedName(value="recallDataAvailable")
    private Boolean recallDataAvailable = null;
    @SerializedName(value="rollback")
    private Boolean rollback = null;

    public VehicleHistory accidentCount(Integer accidentCount) {
        this.accidentCount = accidentCount;
        return this;
    }

    @ApiModelProperty(value="the number of accidents")
    public Integer getAccidentCount() {
        return this.accidentCount;
    }

    public void setAccidentCount(Integer accidentCount) {
        this.accidentCount = accidentCount;
    }

    public VehicleHistory assured(Boolean assured) {
        this.assured = assured;
        return this;
    }

    @ApiModelProperty(value="if the vehicle is considered to be AutoCheck Assured or not. If this feature is not paid for or no data is available, the attribute will not be displayed via the xml")
    public Boolean isAssured() {
        return this.assured;
    }

    public void setAssured(Boolean assured) {
        this.assured = assured;
    }

    public VehicleHistory bbp(BbpEnum bbp) {
        this.bbp = bbp;
        return this;
    }

    @ApiModelProperty(value="Decides the BBP badge to be displayed on report. This attribute will not be displayed if the Assured feature is not paid for or if the VIN has no history")
    public BbpEnum getBbp() {
        return this.bbp;
    }

    public void setBbp(BbpEnum bbp) {
        this.bbp = bbp;
    }

    public VehicleHistory conditionRpt(Boolean conditionRpt) {
        this.conditionRpt = conditionRpt;
        return this;
    }

    @ApiModelProperty(value="if a condition report is available for a vehicle. If this feature is not paid for or no data is available, the attribute will not be displayed via the xml. When a condition report is available for the vehicle then the Condition report URL will be displayed in the history HDATA event section")
    public Boolean isConditionRpt() {
        return this.conditionRpt;
    }

    public void setConditionRpt(Boolean conditionRpt) {
        this.conditionRpt = conditionRpt;
    }

    public VehicleHistory count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(value="the number of historical activity records")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public VehicleHistory estimatedAverageMiles(Integer estimatedAverageMiles) {
        this.estimatedAverageMiles = estimatedAverageMiles;
        return this;
    }

    @ApiModelProperty(value="the estimated average miles")
    public Integer getEstimatedAverageMiles() {
        return this.estimatedAverageMiles;
    }

    public void setEstimatedAverageMiles(Integer estimatedAverageMiles) {
        this.estimatedAverageMiles = estimatedAverageMiles;
    }

    public VehicleHistory historyRecords(List<HistoryRecord> historyRecords) {
        this.historyRecords = historyRecords;
        return this;
    }

    public VehicleHistory addHistoryRecordsItem(HistoryRecord historyRecordsItem) {
        if (this.historyRecords == null) {
            this.historyRecords = new ArrayList<HistoryRecord>();
        }
        this.historyRecords.add(historyRecordsItem);
        return this;
    }

    @ApiModelProperty(value="the list of historical activity for the vehicle")
    public List<HistoryRecord> getHistoryRecords() {
        return this.historyRecords;
    }

    public void setHistoryRecords(List<HistoryRecord> historyRecords) {
        this.historyRecords = historyRecords;
    }

    public VehicleHistory lastOdometer(Integer lastOdometer) {
        this.lastOdometer = lastOdometer;
        return this;
    }

    @ApiModelProperty(value="the last odometer reading")
    public Integer getLastOdometer() {
        return this.lastOdometer;
    }

    public void setLastOdometer(Integer lastOdometer) {
        this.lastOdometer = lastOdometer;
    }

    public VehicleHistory mixedOdometer(Boolean mixedOdometer) {
        this.mixedOdometer = mixedOdometer;
        return this;
    }

    @ApiModelProperty(value="indicates a mixed odometer")
    public Boolean isMixedOdometer() {
        return this.mixedOdometer;
    }

    public void setMixedOdometer(Boolean mixedOdometer) {
        this.mixedOdometer = mixedOdometer;
    }

    public VehicleHistory odometer(Boolean odometer) {
        this.odometer = odometer;
        return this;
    }

    @ApiModelProperty(value="indicates if an odometer reading exists")
    public Boolean isOdometer() {
        return this.odometer;
    }

    public void setOdometer(Boolean odometer) {
        this.odometer = odometer;
    }

    public VehicleHistory recallCount(Integer recallCount) {
        this.recallCount = recallCount;
        return this;
    }

    @ApiModelProperty(value="the number of recalls")
    public Integer getRecallCount() {
        return this.recallCount;
    }

    public void setRecallCount(Integer recallCount) {
        this.recallCount = recallCount;
    }

    public VehicleHistory recallDataAvailable(Boolean recallDataAvailable) {
        this.recallDataAvailable = recallDataAvailable;
        return this;
    }

    @ApiModelProperty(value="indicates if recall data is available")
    public Boolean isRecallDataAvailable() {
        return this.recallDataAvailable;
    }

    public void setRecallDataAvailable(Boolean recallDataAvailable) {
        this.recallDataAvailable = recallDataAvailable;
    }

    public VehicleHistory rollback(Boolean rollback) {
        this.rollback = rollback;
        return this;
    }

    @ApiModelProperty(value="indicates if the vehicle's history determines that the odometer has been tampered with")
    public Boolean isRollback() {
        return this.rollback;
    }

    public void setRollback(Boolean rollback) {
        this.rollback = rollback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VehicleHistory vehicleHistory = (VehicleHistory)o;
        return Objects.equals(this.accidentCount, vehicleHistory.accidentCount) && Objects.equals(this.assured, vehicleHistory.assured) && Objects.equals((Object)this.bbp, (Object)vehicleHistory.bbp) && Objects.equals(this.conditionRpt, vehicleHistory.conditionRpt) && Objects.equals(this.count, vehicleHistory.count) && Objects.equals(this.estimatedAverageMiles, vehicleHistory.estimatedAverageMiles) && Objects.equals(this.historyRecords, vehicleHistory.historyRecords) && Objects.equals(this.lastOdometer, vehicleHistory.lastOdometer) && Objects.equals(this.mixedOdometer, vehicleHistory.mixedOdometer) && Objects.equals(this.odometer, vehicleHistory.odometer) && Objects.equals(this.recallCount, vehicleHistory.recallCount) && Objects.equals(this.recallDataAvailable, vehicleHistory.recallDataAvailable) && Objects.equals(this.rollback, vehicleHistory.rollback);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accidentCount, this.assured, this.bbp, this.conditionRpt, this.count, this.estimatedAverageMiles, this.historyRecords, this.lastOdometer, this.mixedOdometer, this.odometer, this.recallCount, this.recallDataAvailable, this.rollback});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VehicleHistory {\n");
        sb.append("    accidentCount: ").append(this.toIndentedString(this.accidentCount)).append("\n");
        sb.append("    assured: ").append(this.toIndentedString(this.assured)).append("\n");
        sb.append("    bbp: ").append(this.toIndentedString((Object)this.bbp)).append("\n");
        sb.append("    conditionRpt: ").append(this.toIndentedString(this.conditionRpt)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    estimatedAverageMiles: ").append(this.toIndentedString(this.estimatedAverageMiles)).append("\n");
        sb.append("    historyRecords: ").append(this.toIndentedString(this.historyRecords)).append("\n");
        sb.append("    lastOdometer: ").append(this.toIndentedString(this.lastOdometer)).append("\n");
        sb.append("    mixedOdometer: ").append(this.toIndentedString(this.mixedOdometer)).append("\n");
        sb.append("    odometer: ").append(this.toIndentedString(this.odometer)).append("\n");
        sb.append("    recallCount: ").append(this.toIndentedString(this.recallCount)).append("\n");
        sb.append("    recallDataAvailable: ").append(this.toIndentedString(this.recallDataAvailable)).append("\n");
        sb.append("    rollback: ").append(this.toIndentedString(this.rollback)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BbpEnum {
        _0("0"),
        _1("1"),
        _3("3");

        private String value;

        private BbpEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BbpEnum fromValue(String text) {
            for (BbpEnum b : BbpEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<BbpEnum> {
            public void write(JsonWriter jsonWriter, BbpEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BbpEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BbpEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

