/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.model.declaration;

import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.declaration.Variant;
import com.squareup.moshi.JsonClass;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=false)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/autonomousapps/model/declaration/SourceSetKind;", "", "taskNameSuffix", "", "compileClasspathFormatString", "runtimeClasspathFormatString", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTaskNameSuffix", "()Ljava/lang/String;", "asBaseVariant", "Lcom/autonomousapps/model/declaration/Variant;", "customVariantName", "compileClasspathConfigurationName", "variantName", "runtimeClasspathConfigurationName", "MAIN", "TEST", "ANDROID_TEST", "CUSTOM_JVM", "dependency-analysis-gradle-plugin"})
public final class SourceSetKind
extends Enum<SourceSetKind> {
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileClasspathFormatString;
    @NotNull
    private final String runtimeClasspathFormatString;
    public static final /* enum */ SourceSetKind MAIN = new SourceSetKind("Main", "%sCompileClasspath", "%sRuntimeClasspath");
    public static final /* enum */ SourceSetKind TEST = new SourceSetKind("Test", "%sUnitTestCompileClasspath", "%sUnitTestRuntimeClasspath");
    public static final /* enum */ SourceSetKind ANDROID_TEST = new SourceSetKind("androidTest", "%sAndroidTestCompileClasspath", "%sAndroidTestRuntimeClasspath");
    public static final /* enum */ SourceSetKind CUSTOM_JVM = new SourceSetKind("CUSTOM", "%sCompileClasspath", "%sRuntimeClasspath");
    private static final /* synthetic */ SourceSetKind[] $VALUES;

    private SourceSetKind(String taskNameSuffix, String compileClasspathFormatString, String runtimeClasspathFormatString) {
        this.taskNameSuffix = taskNameSuffix;
        this.compileClasspathFormatString = compileClasspathFormatString;
        this.runtimeClasspathFormatString = runtimeClasspathFormatString;
    }

    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @NotNull
    public final String compileClasspathConfigurationName(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        String string = this.compileClasspathFormatString;
        Object[] objectArray = new Object[]{variantName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String runtimeClasspathConfigurationName(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        String string = this.runtimeClasspathFormatString;
        Object[] objectArray = new Object[]{variantName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final Variant asBaseVariant(@Nullable String customVariantName) {
        String string = customVariantName;
        if (string == null) {
            string = UtilsKt.lowercase(this.name());
        }
        return new Variant(string, this);
    }

    public static SourceSetKind[] values() {
        return (SourceSetKind[])$VALUES.clone();
    }

    public static SourceSetKind valueOf(String value) {
        return Enum.valueOf(SourceSetKind.class, value);
    }

    static {
        $VALUES = sourceSetKindArray = new SourceSetKind[]{SourceSetKind.MAIN, SourceSetKind.TEST, SourceSetKind.ANDROID_TEST, SourceSetKind.CUSTOM_JVM};
    }
}

