/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.exception.BuildScriptParseException;
import com.autonomousapps.extension.DependenciesHandler;
import com.autonomousapps.internal.advice.AdvicePrinter;
import com.autonomousapps.internal.advice.DslKind;
import com.autonomousapps.internal.parse.BuildScriptDependenciesRewriter;
import com.autonomousapps.internal.utils.CollectionsKt;
import com.autonomousapps.internal.utils.MoshiUtils;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.Advice;
import com.autonomousapps.model.ProjectAdvice;
import com.squareup.moshi.JsonAdapter;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSource;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/autonomousapps/tasks/RewriteTask;", "Lorg/gradle/api/DefaultTask;", "()V", "buildScript", "Lorg/gradle/api/file/RegularFileProperty;", "getBuildScript", "()Lorg/gradle/api/file/RegularFileProperty;", "dependencyMap", "Lorg/gradle/api/provider/MapProperty;", "", "getDependencyMap", "()Lorg/gradle/api/provider/MapProperty;", "projectAdvice", "getProjectAdvice", "upgrade", "Lorg/gradle/api/provider/Property;", "", "getUpgrade", "()Lorg/gradle/api/provider/Property;", "useTypesafeProjectAccessors", "getUseTypesafeProjectAccessors", "action", "", "filtered", "", "Lcom/autonomousapps/model/Advice;", "isUpgrade", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRewriteTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RewriteTask.kt\ncom/autonomousapps/tasks/RewriteTask\n+ 2 utils.kt\ncom/autonomousapps/internal/utils/UtilsKt\n+ 3 moshi.kt\ncom/autonomousapps/internal/utils/MoshiUtils\n+ 4 collections.kt\ncom/autonomousapps/internal/utils/CollectionsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n117#2,13:91\n40#3,2:104\n33#3,4:106\n76#4:110\n865#5,2:111\n*S KotlinDebug\n*F\n+ 1 RewriteTask.kt\ncom/autonomousapps/tasks/RewriteTask\n*L\n63#1:91,13\n63#1:104,2\n63#1:106,4\n88#1:110\n88#1:111,2\n*E\n"})
public abstract class RewriteTask
extends DefaultTask {
    public RewriteTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Rewrite build script for this project to match dependency advice");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getBuildScript();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getProjectAdvice();

    @Input
    @NotNull
    public abstract MapProperty<String, String> getDependencyMap();

    @Input
    @NotNull
    public abstract Property<Boolean> getUseTypesafeProjectAccessors();

    @Optional
    @Input
    @Option(option="upgrade", description="Use --upgrade if you only want to add or upgrade (implementation -> api) dependencies")
    @NotNull
    public abstract Property<Boolean> getUpgrade();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void action() {
        Object object;
        File file = ((RegularFile)this.getBuildScript().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"buildScript.get().asFile");
        File buildScript = file;
        Object object2 = this.getUpgrade().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"upgrade.getOrElse(false)");
        boolean isUpgrade = (Boolean)object2;
        if (isUpgrade) {
            this.getLogger().quiet("Fixing dependencies for " + buildScript.getPath() + ". Upgrades only.");
        } else {
            this.getLogger().quiet("Fixing dependencies for " + buildScript.getPath() + ".");
        }
        DslKind dslKind = DslKind.Companion.from(buildScript);
        RegularFileProperty $this$fromJson$iv = this.getProjectAdvice();
        boolean $i$f$fromJson = false;
        Object object3 = $this$fromJson$iv.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get()");
        RegularFile $this$fromJson$iv$iv = (RegularFile)object3;
        boolean $i$f$fromJson2 = false;
        File file2 = $this$fromJson$iv$iv.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"asFile");
        File $this$fromJson$iv$iv$iv = file2;
        boolean $i$f$fromJson3 = false;
        Closeable closeable = (Closeable)UtilsKt.access$bufferRead($this$fromJson$iv$iv$iv);
        Throwable throwable = null;
        try {
            BufferedSource reader$iv$iv$iv = (BufferedSource)closeable;
            boolean bl = false;
            boolean withNulls$iv$iv$iv$iv = false;
            boolean $i$f$getJsonAdapter = false;
            JsonAdapter jsonAdapter = MoshiUtils.getMOSHI().adapter(ProjectAdvice.class);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"MOSHI.adapter(T::class.java)");
            JsonAdapter $this$withNulls$iv$iv$iv$iv$iv = jsonAdapter;
            boolean $i$f$withNulls = false;
            Object object4 = $this$withNulls$iv$iv$iv$iv$iv.fromJson(reader$iv$iv$iv);
            Intrinsics.checkNotNull((Object)object4);
            object = object4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ProjectAdvice projectAdvice2 = (ProjectAdvice)object;
        Object object5 = this.getDependencyMap().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"dependencyMap.get()");
        Map map = (Map)object5;
        Set<Advice> set2 = this.filtered(projectAdvice2.getDependencyAdvice(), isUpgrade);
        Function1<String, String> function1 = DependenciesHandler.Companion.toLambda(map);
        Object object6 = this.getUseTypesafeProjectAccessors().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"useTypesafeProjectAccessors.get()");
        BuildScriptDependenciesRewriter rewriter2 = BuildScriptDependenciesRewriter.Companion.of(buildScript, set2, new AdvicePrinter(dslKind, function1, (Boolean)object6), (Function1<? super String, String>)((Function1)new Function1<String, String>((Map<String, String>)map){
            final /* synthetic */ Map<String, String> $map;
            {
                this.$map = $map;
                super(1);
            }

            public final String invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = CollectionsKt.reversed(this.$map).getOrDefault(it, it);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"map.reversed().getOrDefault(it, it)");
                return string;
            }
        }));
        try {
            String newText = rewriter2.rewritten();
            FilesKt.writeText$default((File)buildScript, (String)newText, null, (int)2, null);
        }
        catch (BuildScriptParseException e) {
            this.getLogger().warn("Can't fix dependencies for '" + projectAdvice2.getProjectPath() + "': " + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Advice> filtered(Set<Advice> $this$filtered, boolean isUpgrade) {
        Set set2;
        if (!isUpgrade) {
            set2 = $this$filtered;
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filterToSet$iv = $this$filtered;
            boolean $i$f$filterToSet = false;
            Iterable iterable = $this$filterToSet$iv;
            Collection destination$iv$iv = new HashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Advice it = (Advice)element$iv$iv;
                boolean bl = false;
                if (!it.isUpgrade()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            set2 = (Set)destination$iv$iv;
        }
        return set2;
    }
}

