/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.jetbrains.annotations.NotNull;

@UntrackedTask(because="Prints text to console")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/ProjectGraphTask;", "Lorg/gradle/api/DefaultTask;", "()V", "graphsDir", "Lorg/gradle/api/file/DirectoryProperty;", "getGraphsDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "rootDir", "getRootDir", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class ProjectGraphTask
extends DefaultTask {
    public ProjectGraphTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Generates several graph views of this project's local dependency graph");
    }

    @Input
    @NotNull
    public abstract Property<String> getProjectPath();

    @Internal
    @NotNull
    public abstract DirectoryProperty getRootDir();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getGraphsDir();

    @TaskAction
    public final void action() {
        StringBuilder stringBuilder;
        File file = ((RegularFile)this.getGraphsDir().file("project-compile-classpath.gv").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"graphsDir.file(GenerateP\u2026LASSPATH_GV).get().asFile");
        File compileOutput = file;
        File file2 = ((RegularFile)this.getGraphsDir().file("project-runtime-classpath.gv").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"graphsDir.file(GenerateP\u2026LASSPATH_GV).get().asFile");
        File runtimeOutput = file2;
        File file3 = ((RegularFile)this.getGraphsDir().file("project-combined-classpath.gv").get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"graphsDir.file(GenerateP\u2026LASSPATH_GV).get().asFile");
        File combinedOutput = file3;
        StringBuilder $this$action_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object object = this.getProjectPath().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectPath.get()");
        String svgName = StringsKt.replace$default((String)StringsKt.removePrefix((String)((String)object), (CharSequence)":"), (char)':', (char)'-', (boolean)false, (int)4, null) + ".svg";
        File file4 = ((Directory)this.getRootDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"rootDir.get().asFile");
        File rootPath = file4;
        File compilePath = FilesKt.relativeTo((File)compileOutput, (File)rootPath);
        File runtimePath = FilesKt.relativeTo((File)runtimeOutput, (File)rootPath);
        File combinedPath = FilesKt.relativeTo((File)combinedOutput, (File)rootPath);
        StringBuilder stringBuilder2 = $this$action_u24lambda_u240.append("Graphs generated to:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$action_u24lambda_u240.append(" - " + compilePath);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$action_u24lambda_u240.append(" - " + runtimePath);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$action_u24lambda_u240.append(" - " + combinedPath);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$action_u24lambda_u240.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = $this$action_u24lambda_u240.append("To generate an SVG with graphviz, you could run the following. (You must have graphviz installed.)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)$this$action_u24lambda_u240.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$action_u24lambda_u240.append("    dot -Tsvg " + runtimePath + " -o " + svgName);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String msg2 = string;
        this.getLogger().quiet(msg2);
    }
}

