/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.tasks;

import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.internal.utils.VersionCatalogKt;
import com.autonomousapps.tasks.ComputeResolvedDependenciesTask;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/autonomousapps/tasks/ComputeResolvedDependenciesTask;", "Lorg/gradle/api/DefaultTask;", "()V", "externalDependencies", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/RegularFile;", "getExternalDependencies", "()Lorg/gradle/api/provider/ListProperty;", "output", "Lorg/gradle/api/file/RegularFileProperty;", "getOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "outputToml", "getOutputToml", "action", "", "dependency-analysis-gradle-plugin"})
public abstract class ComputeResolvedDependenciesTask
extends DefaultTask {
    public ComputeResolvedDependenciesTask() {
        this.setGroup("dependency-analysis");
        this.setDescription("Computes resolved external dependencies for all variants.");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public abstract ListProperty<RegularFile> getExternalDependencies();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutput();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputToml();

    @TaskAction
    public final void action() {
        File output = UtilsKt.getAndDelete(this.getOutput());
        File outputToml = UtilsKt.getAndDelete(this.getOutputToml());
        Object object = this.getExternalDependencies().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"externalDependencies.get()");
        Set dependencies2 = SequencesKt.toSortedSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)object)), (Function1)action.dependencies.1.INSTANCE), (Function1)action.dependencies.2.INSTANCE));
        FilesKt.writeText$default((File)output, (String)CollectionsKt.joinToString$default((Iterable)dependencies2, (CharSequence)"\n", null, null, (int)0, null, (Function1)action.1.INSTANCE, (int)30, null), null, (int)2, null);
        FilesKt.writeText$default((File)outputToml, (String)VersionCatalogKt.toVersionCatalog(dependencies2), null, (int)2, null);
    }
}

