/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.analyzer;

import com.android.build.gradle.api.BaseVariant;
import com.android.builder.model.SourceProvider;
import com.autonomousapps.internal.ArtifactViewsKt;
import com.autonomousapps.internal.OutputPaths;
import com.autonomousapps.internal.analyzer.AbstractDependencyAnalyzer;
import com.autonomousapps.internal.analyzer.AndroidAnalyzer;
import com.autonomousapps.internal.analyzer.Language;
import com.autonomousapps.internal.analyzer.VariantSourceSet;
import com.autonomousapps.internal.android.AndroidGradlePlugin;
import com.autonomousapps.internal.android.AndroidGradlePluginFactory;
import com.autonomousapps.internal.utils.TasksKt;
import com.autonomousapps.internal.utils.UtilsKt;
import com.autonomousapps.model.declaration.SourceSetKind;
import com.autonomousapps.services.InMemoryCache;
import com.autonomousapps.tasks.AssetSourceExploderTask;
import com.autonomousapps.tasks.ClassListExploderTask;
import com.autonomousapps.tasks.FindAndroidAssetProviders;
import com.autonomousapps.tasks.FindAndroidLinters;
import com.autonomousapps.tasks.FindAndroidResTask;
import com.autonomousapps.tasks.FindDeclaredProcsTask;
import com.autonomousapps.tasks.FindNativeLibsTask;
import com.autonomousapps.tasks.ManifestComponentsExtractionTask;
import com.autonomousapps.tasks.XmlSourceExploderTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010F\u001a\u00020\tH\u0002J\b\u0010G\u001a\u00020\u001dH\u0002J\b\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020\u001dH\u0002J\b\u0010K\u001a\u00020\u001dH\u0002J\b\u0010L\u001a\u00020\u001dH\u0002J\b\u0010M\u001a\u00020\u001dH\u0002J\b\u0010N\u001a\u00020IH\u0002J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020Q0PH\u0002J\b\u0010R\u001a\u00020\tH\u0002J\u0010\u0010S\u001a\n\u0012\u0004\u0012\u00020Q\u0018\u00010PH\u0002J\f\u0010T\u001a\b\u0012\u0004\u0012\u00020U0PJ\f\u0010V\u001a\b\u0012\u0004\u0012\u00020W0PJ\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Y0PJ\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020[0PJ\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0PJ\f\u0010^\u001a\b\u0012\u0004\u0012\u00020_0PJ\f\u0010`\u001a\b\u0012\u0004\u0012\u00020a0PJ\f\u0010b\u001a\b\u0012\u0004\u0012\u00020c0PJ\f\u0010d\u001a\b\u0012\u0004\u0012\u00020e0PR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0011\u0010#\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001fR\u0011\u0010%\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0011R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001fR\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0011R\u0011\u00103\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001fR\u0011\u00105\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0011R\u0013\u00107\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0011R\u0011\u00109\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0011R\u0011\u0010;\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010?\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0011R\u0011\u0010A\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006f"}, d2={"Lcom/autonomousapps/internal/analyzer/AndroidAnalyzer;", "Lcom/autonomousapps/internal/analyzer/AbstractDependencyAnalyzer;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "variantSourceSet", "Lcom/autonomousapps/internal/analyzer/VariantSourceSet;", "agpVersion", "", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/api/BaseVariant;Lcom/autonomousapps/internal/analyzer/VariantSourceSet;Ljava/lang/String;)V", "agp", "Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "getAgp", "()Lcom/autonomousapps/internal/android/AndroidGradlePlugin;", "annotationProcessorConfigurationName", "getAnnotationProcessorConfigurationName", "()Ljava/lang/String;", "attributeValueJar", "getAttributeValueJar", "buildType", "getBuildType", "compileConfigurationName", "getCompileConfigurationName", "dataBindingEnabled", "", "flavorName", "getFlavorName", "groovySourceFiles", "Lorg/gradle/api/file/FileCollection;", "getGroovySourceFiles", "()Lorg/gradle/api/file/FileCollection;", "isDataBindingEnabled", "()Z", "isViewBindingEnabled", "javaSourceFiles", "getJavaSourceFiles", "kaptConfigurationName", "getKaptConfigurationName", "kind", "Lcom/autonomousapps/model/declaration/SourceSetKind;", "getKind", "()Lcom/autonomousapps/model/declaration/SourceSetKind;", "kotlinSourceFiles", "getKotlinSourceFiles", "outputPaths", "Lcom/autonomousapps/internal/OutputPaths;", "getOutputPaths", "()Lcom/autonomousapps/internal/OutputPaths;", "runtimeConfigurationName", "getRuntimeConfigurationName", "scalaSourceFiles", "getScalaSourceFiles", "taskNameSuffix", "getTaskNameSuffix", "testInstrumentationRunner", "getTestInstrumentationRunner", "testJavaCompileName", "getTestJavaCompileName", "testKotlinCompileName", "getTestKotlinCompileName", "getVariant", "()Lcom/android/build/gradle/api/BaseVariant;", "variantName", "getVariantName", "variantNameCapitalized", "getVariantNameCapitalized", "getVariantSourceSet", "()Lcom/autonomousapps/internal/analyzer/VariantSourceSet;", "viewBindingEnabled", "computeTaskNameSuffix", "getAndroidAssets", "getAndroidRes", "Lorg/gradle/api/file/FileTree;", "getGroovySources", "getJavaSources", "getKotlinSources", "getScalaSources", "getSourceDirectories", "javaCompileTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "kaptConfName", "kotlinCompileTask", "registerByteCodeSourceExploderTask", "Lcom/autonomousapps/tasks/ClassListExploderTask;", "registerExplodeAssetSourceTask", "Lcom/autonomousapps/tasks/AssetSourceExploderTask;", "registerExplodeXmlSourceTask", "Lcom/autonomousapps/tasks/XmlSourceExploderTask;", "registerFindAndroidAssetProvidersTask", "Lcom/autonomousapps/tasks/FindAndroidAssetProviders;", "registerFindAndroidLintersTask", "Lcom/autonomousapps/tasks/FindAndroidLinters;", "registerFindAndroidResTask", "Lcom/autonomousapps/tasks/FindAndroidResTask;", "registerFindDeclaredProcsTask", "Lcom/autonomousapps/tasks/FindDeclaredProcsTask;", "registerFindNativeLibsTask", "Lcom/autonomousapps/tasks/FindNativeLibsTask;", "registerManifestComponentsExtractionTask", "Lcom/autonomousapps/tasks/ManifestComponentsExtractionTask;", "dependency-analysis-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAndroidProjectAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/AndroidAnalyzer\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n254#2:276\n254#2:277\n254#2:278\n254#2:279\n254#2:280\n254#2:281\n254#2:282\n254#2:283\n254#2:284\n1360#3:285\n1446#3,5:286\n1549#3:291\n1620#3,3:292\n1549#3:295\n1620#3,3:296\n1549#3:299\n1620#3,3:300\n766#3:303\n857#3,2:304\n766#3:306\n857#3,2:307\n1360#3:309\n1446#3,5:310\n766#3:315\n857#3,2:316\n1360#3:318\n1446#3,5:319\n766#3:324\n857#3,2:325\n*S KotlinDebug\n*F\n+ 1 AndroidProjectAnalyzer.kt\ncom/autonomousapps/internal/analyzer/AndroidAnalyzer\n*L\n68#1:276\n78#1:277\n88#1:278\n98#1:279\n108#1:280\n115#1:281\n122#1:282\n128#1:283\n134#1:284\n193#1:285\n193#1:286,5\n198#1:291\n198#1:292,3\n199#1:295\n199#1:296,3\n200#1:299\n200#1:300,3\n201#1:303\n201#1:304,2\n204#1:306\n204#1:307,2\n208#1:309\n208#1:310,5\n210#1:315\n210#1:316,2\n218#1:318\n218#1:319,5\n220#1:324\n220#1:325,2\n*E\n"})
public abstract class AndroidAnalyzer
extends AbstractDependencyAnalyzer {
    @NotNull
    private final BaseVariant variant;
    @NotNull
    private final VariantSourceSet variantSourceSet;
    @NotNull
    private final AndroidGradlePlugin agp;
    private final boolean dataBindingEnabled;
    private final boolean viewBindingEnabled;
    @NotNull
    private final String flavorName;
    @NotNull
    private final String variantName;
    @NotNull
    private final String buildType;
    @NotNull
    private final SourceSetKind kind;
    @NotNull
    private final String variantNameCapitalized;
    @NotNull
    private final String taskNameSuffix;
    @NotNull
    private final String compileConfigurationName;
    @NotNull
    private final String runtimeConfigurationName;
    @NotNull
    private final String kaptConfigurationName;
    @NotNull
    private final String annotationProcessorConfigurationName;
    @Nullable
    private final String testInstrumentationRunner;
    @NotNull
    private final FileCollection kotlinSourceFiles;
    @NotNull
    private final FileCollection javaSourceFiles;
    @NotNull
    private final FileCollection groovySourceFiles;
    @NotNull
    private final FileCollection scalaSourceFiles;
    @NotNull
    private final String attributeValueJar;
    private final boolean isDataBindingEnabled;
    private final boolean isViewBindingEnabled;
    @NotNull
    private final OutputPaths outputPaths;
    @NotNull
    private final String testJavaCompileName;
    @NotNull
    private final String testKotlinCompileName;

    public AndroidAnalyzer(@NotNull Project project, @NotNull BaseVariant variant, @NotNull VariantSourceSet variantSourceSet, @NotNull String agpVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)variantSourceSet, (String)"variantSourceSet");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        super(project);
        this.variant = variant;
        this.variantSourceSet = variantSourceSet;
        this.agp = new AndroidGradlePluginFactory(project, agpVersion).newAdapter();
        this.dataBindingEnabled = this.agp.isDataBindingEnabled();
        this.viewBindingEnabled = this.agp.isViewBindingEnabled();
        String string = this.variant.getFlavorName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.flavorName");
        this.flavorName = string;
        String string2 = this.variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
        this.variantName = string2;
        this.buildType = this.variant.getBuildType().getName();
        this.kind = this.variantSourceSet.getVariant().getKind();
        this.variantNameCapitalized = UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null);
        this.taskNameSuffix = this.computeTaskNameSuffix();
        this.compileConfigurationName = this.variantSourceSet.getCompileClasspathConfigurationName();
        this.runtimeConfigurationName = this.variantSourceSet.getRuntimeClasspathConfigurationName();
        this.kaptConfigurationName = this.kaptConfName();
        this.annotationProcessorConfigurationName = this.variantName + "AnnotationProcessorClasspath";
        this.testInstrumentationRunner = this.variant.getMergedFlavor().getTestInstrumentationRunner();
        this.kotlinSourceFiles = this.getKotlinSources();
        this.javaSourceFiles = this.getJavaSources();
        this.groovySourceFiles = this.getGroovySources();
        this.scalaSourceFiles = this.getScalaSources();
        this.attributeValueJar = "android-classes";
        this.isDataBindingEnabled = this.dataBindingEnabled;
        this.isViewBindingEnabled = this.viewBindingEnabled;
        this.outputPaths = new OutputPaths(project, this.variantName + this.kind.getTaskNameSuffix());
        this.testJavaCompileName = "compile" + this.variantNameCapitalized + "UnitTestJavaWithJavac";
        this.testKotlinCompileName = "compile" + this.variantNameCapitalized + "UnitTestKotlin";
    }

    @NotNull
    protected final BaseVariant getVariant() {
        return this.variant;
    }

    @NotNull
    protected final VariantSourceSet getVariantSourceSet() {
        return this.variantSourceSet;
    }

    @NotNull
    protected final AndroidGradlePlugin getAgp() {
        return this.agp;
    }

    @Override
    @NotNull
    public final String getFlavorName() {
        return this.flavorName;
    }

    @Override
    @NotNull
    public final String getVariantName() {
        return this.variantName;
    }

    @Override
    @NotNull
    public final String getBuildType() {
        return this.buildType;
    }

    @Override
    @NotNull
    public final SourceSetKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public final String getVariantNameCapitalized() {
        return this.variantNameCapitalized;
    }

    @Override
    @NotNull
    public final String getTaskNameSuffix() {
        return this.taskNameSuffix;
    }

    @Override
    @NotNull
    public final String getCompileConfigurationName() {
        return this.compileConfigurationName;
    }

    @Override
    @NotNull
    public final String getRuntimeConfigurationName() {
        return this.runtimeConfigurationName;
    }

    @Override
    @NotNull
    public final String getKaptConfigurationName() {
        return this.kaptConfigurationName;
    }

    @Override
    @NotNull
    public final String getAnnotationProcessorConfigurationName() {
        return this.annotationProcessorConfigurationName;
    }

    @Override
    @Nullable
    public final String getTestInstrumentationRunner() {
        return this.testInstrumentationRunner;
    }

    @Override
    @NotNull
    public final FileCollection getKotlinSourceFiles() {
        return this.kotlinSourceFiles;
    }

    @Override
    @NotNull
    public final FileCollection getJavaSourceFiles() {
        return this.javaSourceFiles;
    }

    @Override
    @NotNull
    public final FileCollection getGroovySourceFiles() {
        return this.groovySourceFiles;
    }

    @Override
    @NotNull
    public final FileCollection getScalaSourceFiles() {
        return this.scalaSourceFiles;
    }

    @Override
    @NotNull
    public final String getAttributeValueJar() {
        return this.attributeValueJar;
    }

    @Override
    public final boolean isDataBindingEnabled() {
        return this.isDataBindingEnabled;
    }

    @Override
    public final boolean isViewBindingEnabled() {
        return this.isViewBindingEnabled;
    }

    @Override
    @NotNull
    public final OutputPaths getOutputPaths() {
        return this.outputPaths;
    }

    @Override
    @NotNull
    public final String getTestJavaCompileName() {
        return this.testJavaCompileName;
    }

    @Override
    @NotNull
    public final String getTestKotlinCompileName() {
        return this.testKotlinCompileName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<ClassListExploderTask> registerByteCodeSourceExploderTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeByteCodeSource" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<ClassListExploderTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ClassListExploderTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.getClasses().setFrom((Iterable)$this$register.getProject().files(new Object[0]));
                TaskProvider taskProvider = AndroidAnalyzer.access$kotlinCompileTask(this.this$0);
                if (taskProvider != null) {
                    TaskProvider it = taskProvider;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{((Task)it.get()).getOutputs().getFiles().getAsFileTree()};
                    $this$register.getKotlinClasses().from(objectArray);
                }
                Object[] objectArray = new Object[]{((Task)AndroidAnalyzer.access$javaCompileTask(this.this$0).get()).getOutputs().getFiles().getAsFileTree()};
                $this$register.getJavaClasses().from(objectArray);
                $this$register.getOutput().set(this.this$0.getOutputPaths().getExplodingBytecodePath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, ClassListExploderTask.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<ManifestComponentsExtractionTask> registerManifestComponentsExtractionTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "extractPackageNameFromManifest" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<ManifestComponentsExtractionTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ManifestComponentsExtractionTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setArtifacts(ArtifactViewsKt.artifactsFor((Configuration)object, "android-manifest"));
                $this$register.getNamespace().set(this.this$0.getAgp().namespace());
                $this$register.getOutput().set(this.this$0.getOutputPaths().getManifestPackagesPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, ManifestComponentsExtractionTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindAndroidResTask> registerFindAndroidResTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidResImports" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindAndroidResTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FindAndroidResTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setAndroidSymbols(ArtifactViewsKt.artifactsFor((Configuration)object, "android-symbol-with-package-name"));
                ConfigurationContainer configurationContainer2 = $this$register.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer2, (String)"project.configurations");
                Object object2 = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer2), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"project.configurations[compileConfigurationName]");
                $this$register.setAndroidPublicRes(ArtifactViewsKt.artifactsFor((Configuration)object2, "android-public-res"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidResPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidResTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<XmlSourceExploderTask> registerExplodeXmlSourceTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeXmlSource" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<XmlSourceExploderTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull XmlSourceExploderTask $this$register) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable list$iv$iv;
                SourceProvider it;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.getAndroidLocalRes().setFrom((Iterable)AndroidAnalyzer.access$getAndroidRes(this.this$0));
                List list = this.this$0.getVariant().getSourceSets();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
                Iterable iterable = list;
                XmlSourceExploderTask xmlSourceExploderTask = $this$register;
                boolean $i$f$flatMap = false;
                void var4_5 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (SourceProvider)element$iv$iv;
                    boolean bl = false;
                    Collection collection = it.getResDirectories();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.resDirectories");
                    list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                xmlSourceExploderTask.layouts$dependency_analysis_gradle_plugin((List)destination$iv$iv);
                ConfigurableFileCollection configurableFileCollection = $this$register.getManifestFiles();
                List list2 = this.this$0.getVariant().getSourceSets();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"variant.sourceSets");
                $this$flatMap$iv = list2;
                xmlSourceExploderTask = configurableFileCollection;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    list$iv$iv = (SourceProvider)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getManifestFile());
                }
                xmlSourceExploderTask.setFrom((List)destination$iv$iv);
                $this$register.getNamespace().set(this.this$0.getAgp().namespace());
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidResToResUsagePath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, XmlSourceExploderTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<AssetSourceExploderTask> registerExplodeAssetSourceTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "explodeAssetSource" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<AssetSourceExploderTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AssetSourceExploderTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                $this$register.getAndroidLocalAssets().setFrom((Iterable)AndroidAnalyzer.access$getAndroidAssets(this.this$0));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidAssetSourcePath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, AssetSourceExploderTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindNativeLibsTask> registerFindNativeLibsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findNativeLibs" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindNativeLibsTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FindNativeLibsTask $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setAndroidJni(ArtifactViewsKt.artifactsFor((Configuration)object, "android-jni"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getNativeDependenciesPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindNativeLibsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindAndroidLinters> registerFindAndroidLintersTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidLinters" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindAndroidLinters, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FindAndroidLinters $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getCompileConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[compileConfigurationName]");
                $this$register.setLintJars(ArtifactViewsKt.artifactsFor((Configuration)object, "android-lint"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidLintersPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidLinters.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindAndroidAssetProviders> registerFindAndroidAssetProvidersTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findAndroidAssetProviders" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindAndroidAssetProviders, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FindAndroidAssetProviders $this$register) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                ConfigurationContainer configurationContainer = $this$register.getProject().getConfigurations();
                Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
                Object object = NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)configurationContainer), (String)this.this$0.getRuntimeConfigurationName());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations[runtimeConfigurationName]");
                $this$register.setAssets(ArtifactViewsKt.artifactsFor((Configuration)object, "android-assets"));
                $this$register.getOutput().set(this.this$0.getOutputPaths().getAndroidAssetsPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindAndroidAssetProviders.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final TaskProvider<FindDeclaredProcsTask> registerFindDeclaredProcsTask() {
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = this.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "findDeclaredProcs" + this.taskNameSuffix;
        Function1 configuration$iv = (Function1)new Function1<FindDeclaredProcsTask, Unit>(this){
            final /* synthetic */ AndroidAnalyzer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FindDeclaredProcsTask $this$register) {
                Configuration it;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$register), (String)"$this$register");
                Property<InMemoryCache> property = $this$register.getInMemoryCacheProvider();
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                property.set(InMemoryCache.Companion.register$dependency_analysis_gradle_plugin(project));
                Configuration configuration = this.this$0.kaptConf();
                if (configuration != null) {
                    it = configuration;
                    boolean bl = false;
                    ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"it.incoming.artifacts");
                    $this$register.setKaptArtifacts(artifactCollection);
                }
                Configuration configuration2 = this.this$0.annotationProcessorConf();
                if (configuration2 != null) {
                    it = configuration2;
                    boolean bl = false;
                    ArtifactCollection artifactCollection = it.getIncoming().getArtifacts();
                    Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"it.incoming.artifacts");
                    $this$register.setAnnotationProcessorArtifacts(artifactCollection);
                }
                $this$register.getOutput().set(this.this$0.getOutputPaths().getDeclaredProcPath());
            }
        };
        boolean $i$f$register = false;
        TaskProvider taskProvider = $this$register$iv.register((String)name$iv, FindDeclaredProcsTask.class, new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        return taskProvider;
    }

    private final String kaptConfName() {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.variantSourceSet.getVariant().getKind().ordinal()]) {
            case 1: {
                object = "kapt" + this.variantNameCapitalized;
                break;
            }
            case 2: {
                object = "kaptTest";
                break;
            }
            case 3: {
                object = "kaptAndroidTest";
                break;
            }
            case 4: {
                throw new IllegalStateException("Custom JVM source sets are not supported in Android context".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final TaskProvider<Task> kotlinCompileTask() {
        TaskProvider<Task> taskProvider;
        switch (WhenMappings.$EnumSwitchMapping$0[this.variantSourceSet.getVariant().getKind().ordinal()]) {
            case 1: {
                TaskContainer taskContainer = this.getProject().getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                taskProvider = TasksKt.namedOrNull(taskContainer, "compile" + this.variantNameCapitalized + "Kotlin");
                break;
            }
            case 2: {
                TaskContainer taskContainer = this.getProject().getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                taskProvider = TasksKt.namedOrNull(taskContainer, "compile" + this.variantNameCapitalized + "UnitTestKotlin");
                break;
            }
            case 3: {
                TaskContainer taskContainer = this.getProject().getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
                taskProvider = TasksKt.namedOrNull(taskContainer, "compile" + this.variantNameCapitalized + "AndroidTestKotlin");
                break;
            }
            case 4: {
                throw new IllegalStateException("Custom JVM source sets are not supported in Android context".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return taskProvider;
    }

    private final TaskProvider<Task> javaCompileTask() {
        TaskProvider taskProvider;
        switch (WhenMappings.$EnumSwitchMapping$0[this.variantSourceSet.getVariant().getKind().ordinal()]) {
            case 1: {
                TaskProvider taskProvider2 = this.getProject().getTasks().named("compile" + this.variantNameCapitalized + "JavaWithJavac");
                taskProvider = taskProvider2;
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider2, (String)"project.tasks.named(\"com\u2026pitalized}JavaWithJavac\")");
                break;
            }
            case 2: {
                TaskProvider taskProvider3 = this.getProject().getTasks().named("compile" + this.variantNameCapitalized + "UnitTestJavaWithJavac");
                taskProvider = taskProvider3;
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider3, (String)"project.tasks.named(\"com\u2026d}UnitTestJavaWithJavac\")");
                break;
            }
            case 3: {
                TaskProvider taskProvider4 = this.getProject().getTasks().named("compile" + this.variantNameCapitalized + "AndroidTestJavaWithJavac");
                taskProvider = taskProvider4;
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider4, (String)"project.tasks.named(\"com\u2026ndroidTestJavaWithJavac\")");
                break;
            }
            case 4: {
                throw new IllegalStateException("Custom JVM source sets are not supported in Android context".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return taskProvider;
    }

    private final String computeTaskNameSuffix() {
        return this.variantSourceSet.getVariant().getKind() == SourceSetKind.MAIN ? UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null) : UtilsKt.capitalizeSafely$default(this.variantName, null, 1, null) + this.variantSourceSet.getVariant().getKind().getTaskNameSuffix();
    }

    private final FileCollection getGroovySources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.GROOVY));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026ilterOf(Language.GROOVY))");
        return (FileCollection)fileTree;
    }

    private final FileCollection getJavaSources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.JAVA));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026.filterOf(Language.JAVA))");
        return (FileCollection)fileTree;
    }

    private final FileCollection getKotlinSources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.KOTLIN));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026ilterOf(Language.KOTLIN))");
        return (FileCollection)fileTree;
    }

    private final FileCollection getScalaSources() {
        FileTree fileTree = this.getSourceDirectories().matching(Language.Companion.filterOf(Language.SCALA));
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"getSourceDirectories().m\u2026filterOf(Language.SCALA))");
        return (FileCollection)fileTree;
    }

    /*
     * WARNING - void declaration
     */
    private final FileTree getSourceDirectories() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable $this$filterTo$iv$iv2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.variantSourceSet.getAndroidSourceSets();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SourceProvider it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            Collection collection2 = it.getJavaDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"it.javaDirectories");
            Iterable list$iv$iv = collection2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List javaDirs = (List)destination$iv$iv;
        Iterable $this$map$iv = javaDirs;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File bl = (File)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getPath());
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(StringsKt.removeSuffix((String)it, (CharSequence)"java") + "kotlin");
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new File(it));
        }
        Iterable $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List kotlinDirs = (List)destination$iv$iv2;
        Object[] objectArray = new Object[1];
        $this$filterTo$iv$iv2 = javaDirs;
        int n = 0;
        Object[] objectArray2 = objectArray;
        collection = this.getProject();
        boolean $i$f$filter2 = false;
        void $i$f$filterTo22 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv3;
        objectArray2[n] = CollectionsKt.plus((Collection)list, (Iterable)kotlinDirs);
        FileTree fileTree = collection.files(objectArray).getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.files(javaDirs.f\u2026 + kotlinDirs).asFileTree");
        return fileTree;
    }

    /*
     * WARNING - void declaration
     */
    private final FileTree getAndroidRes() {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        List list = this.variant.getSourceSets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            Collection collection = it.getResDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.resDirectories");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!((File)it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List resDirs = (List)destination$iv$iv;
        Object[] objectArray = new Object[]{resDirs};
        FileTree fileTree = this.getProject().files(objectArray).getAsFileTree().matching((Action)getAndroidRes.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.files(resDirs).a\u2026include(\"**/*.xml\")\n    }");
        return fileTree;
    }

    /*
     * WARNING - void declaration
     */
    private final FileCollection getAndroidAssets() {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        List list = this.variant.getSourceSets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.sourceSets");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (SourceProvider)element$iv$iv;
            boolean bl = false;
            Collection collection = it.getAssetsDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"it.assetsDirectories");
            Iterable list$iv$iv = collection;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!((File)it).exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List assetsDirs = (List)destination$iv$iv;
        Object[] objectArray = new Object[]{assetsDirs};
        FileTree fileTree = this.getProject().files(objectArray).getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.files(assetsDirs).asFileTree");
        return (FileCollection)fileTree;
    }

    public static final /* synthetic */ TaskProvider access$kotlinCompileTask(AndroidAnalyzer $this) {
        return $this.kotlinCompileTask();
    }

    public static final /* synthetic */ TaskProvider access$javaCompileTask(AndroidAnalyzer $this) {
        return $this.javaCompileTask();
    }

    public static final /* synthetic */ FileTree access$getAndroidRes(AndroidAnalyzer $this) {
        return $this.getAndroidRes();
    }

    public static final /* synthetic */ FileCollection access$getAndroidAssets(AndroidAnalyzer $this) {
        return $this.getAndroidAssets();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceSetKind.values().length];
            try {
                nArray[SourceSetKind.MAIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceSetKind.TEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceSetKind.ANDROID_TEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceSetKind.CUSTOM_JVM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

