/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.json;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import shadow.javax.json.JsonArray;
import shadow.javax.json.JsonObject;
import shadow.javax.json.stream.JsonParser;
import shadow.javax.json.stream.JsonParserFactory;
import shadow.org.glassfish.json.JsonParserImpl;
import shadow.org.glassfish.json.JsonStructureParser;
import shadow.org.glassfish.json.api.BufferPool;

class JsonParserFactoryImpl
implements JsonParserFactory {
    private final Map<String, ?> config = Collections.emptyMap();
    private final BufferPool bufferPool;

    JsonParserFactoryImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return new JsonParserImpl(reader, this.bufferPool);
    }

    @Override
    public JsonParser createParser(InputStream in) {
        return new JsonParserImpl(in, this.bufferPool);
    }

    @Override
    public JsonParser createParser(InputStream in, Charset charset) {
        return new JsonParserImpl(in, charset, this.bufferPool);
    }

    @Override
    public JsonParser createParser(JsonArray array) {
        return new JsonStructureParser(array);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.config;
    }

    @Override
    public JsonParser createParser(JsonObject object) {
        return new JsonStructureParser(object);
    }
}

