/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.ibm.icu.impl.number.parse;

import java.util.EnumMap;
import java.util.Map;
import shadow.com.ibm.icu.text.UnicodeSet;

public class UnicodeSetStaticCache {
    private static final Map<Key, UnicodeSet> unicodeSets = new EnumMap<Key, UnicodeSet>(Key.class);

    public static UnicodeSet get(Key key) {
        return unicodeSets.get((Object)key);
    }

    public static Key chooseFrom(String str, Key key1) {
        return UnicodeSetStaticCache.get(key1).contains(str) ? key1 : null;
    }

    public static Key chooseFrom(String str, Key key1, Key key2) {
        return UnicodeSetStaticCache.get(key1).contains(str) ? key1 : UnicodeSetStaticCache.chooseFrom(str, key2);
    }

    public static Key chooseFrom(String str, Key key1, Key key2, Key key3) {
        return UnicodeSetStaticCache.get(key1).contains(str) ? key1 : UnicodeSetStaticCache.chooseFrom(str, key2, key3);
    }

    private static UnicodeSet computeUnion(Key k1, Key k2) {
        return new UnicodeSet().addAll(UnicodeSetStaticCache.get(k1)).addAll(UnicodeSetStaticCache.get(k2)).freeze();
    }

    private static UnicodeSet computeUnion(Key k1, Key k2, Key k3) {
        return new UnicodeSet().addAll(UnicodeSetStaticCache.get(k1)).addAll(UnicodeSetStaticCache.get(k2)).addAll(UnicodeSetStaticCache.get(k3)).freeze();
    }

    static {
        unicodeSets.put(Key.BIDI, new UnicodeSet("[[\\u200E\\u200F\\u061C]]").freeze());
        unicodeSets.put(Key.WHITESPACE, new UnicodeSet("[[:Zs:][\\u0009]]").freeze());
        unicodeSets.put(Key.DEFAULT_IGNORABLES, UnicodeSetStaticCache.computeUnion(Key.BIDI, Key.WHITESPACE));
        unicodeSets.put(Key.STRICT_IGNORABLES, UnicodeSetStaticCache.get(Key.BIDI));
        unicodeSets.put(Key.COMMA, new UnicodeSet("[,\u060c\u066b\u3001\ufe10\ufe11\ufe50\ufe51\uff0c\uff64]").freeze());
        unicodeSets.put(Key.STRICT_COMMA, new UnicodeSet("[,\u066b\ufe10\ufe50\uff0c]").freeze());
        unicodeSets.put(Key.PERIOD, new UnicodeSet("[.\u2024\u3002\ufe12\ufe52\uff0e\uff61]").freeze());
        unicodeSets.put(Key.STRICT_PERIOD, new UnicodeSet("[.\u2024\ufe52\uff0e\uff61]").freeze());
        unicodeSets.put(Key.OTHER_GROUPING_SEPARATORS, new UnicodeSet("['\u066c\u2018\u2019\uff07\\u0020\\u00A0\\u2000-\\u200A\\u202F\\u205F\\u3000]").freeze());
        unicodeSets.put(Key.ALL_SEPARATORS, UnicodeSetStaticCache.computeUnion(Key.COMMA, Key.PERIOD, Key.OTHER_GROUPING_SEPARATORS));
        unicodeSets.put(Key.STRICT_ALL_SEPARATORS, UnicodeSetStaticCache.computeUnion(Key.STRICT_COMMA, Key.STRICT_PERIOD, Key.OTHER_GROUPING_SEPARATORS));
        unicodeSets.put(Key.MINUS_SIGN, new UnicodeSet("[-\u207b\u208b\u2212\u2796\ufe63\uff0d]").freeze());
        unicodeSets.put(Key.PLUS_SIGN, new UnicodeSet("[+\u207a\u208a\u2795\ufb29\ufe62\uff0b]").freeze());
        unicodeSets.put(Key.PERCENT_SIGN, new UnicodeSet("[%\u066a]").freeze());
        unicodeSets.put(Key.PERMILLE_SIGN, new UnicodeSet("[\u2030\u0609]").freeze());
        unicodeSets.put(Key.INFINITY, new UnicodeSet("[\u221e]").freeze());
        unicodeSets.put(Key.DIGITS, new UnicodeSet("[:digit:]").freeze());
        unicodeSets.put(Key.NAN_LEAD, new UnicodeSet("[Nn\u0422\u0442me\u0548\u0578\u0441\u00a4\u041d\u043d\u0447Tts\u04b3\u975e\u1002\u0e9a\u10d0\u0f68\u0644\u0646]").freeze());
        unicodeSets.put(Key.SCIENTIFIC_LEAD, new UnicodeSet("[Ee\u00d7\u00b7\u0435\u0627]").freeze());
        unicodeSets.put(Key.CWCF, new UnicodeSet("[:CWCF:]").freeze());
        unicodeSets.put(Key.DIGITS_OR_ALL_SEPARATORS, UnicodeSetStaticCache.computeUnion(Key.DIGITS, Key.ALL_SEPARATORS));
        unicodeSets.put(Key.DIGITS_OR_STRICT_ALL_SEPARATORS, UnicodeSetStaticCache.computeUnion(Key.DIGITS, Key.STRICT_ALL_SEPARATORS));
    }

    public static enum Key {
        BIDI,
        WHITESPACE,
        DEFAULT_IGNORABLES,
        STRICT_IGNORABLES,
        COMMA,
        PERIOD,
        STRICT_COMMA,
        STRICT_PERIOD,
        OTHER_GROUPING_SEPARATORS,
        ALL_SEPARATORS,
        STRICT_ALL_SEPARATORS,
        MINUS_SIGN,
        PLUS_SIGN,
        PERCENT_SIGN,
        PERMILLE_SIGN,
        INFINITY,
        DIGITS,
        NAN_LEAD,
        SCIENTIFIC_LEAD,
        CWCF,
        DIGITS_OR_ALL_SEPARATORS,
        DIGITS_OR_STRICT_ALL_SEPARATORS;

    }
}

