/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.graph;

import com.autonomousapps.graph.DependencyGraph;
import com.autonomousapps.graph.Edge;
import com.autonomousapps.graph.Node;
import com.autonomousapps.graph.NodePrinter;
import com.autonomousapps.graph.PathPrinter;
import com.autonomousapps.graph.ProducerNode;
import com.autonomousapps.graph.Reason;
import com.autonomousapps.graph.ShortestPath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/autonomousapps/graph/NoReason;", "Lcom/autonomousapps/graph/Reason;", "graph", "Lcom/autonomousapps/graph/DependencyGraph;", "queryNode", "Lcom/autonomousapps/graph/ProducerNode;", "(Lcom/autonomousapps/graph/DependencyGraph;Lcom/autonomousapps/graph/ProducerNode;)V", "adviceText", "", "infoText", "path", "", "Lcom/autonomousapps/graph/Edge;", "getPath", "()Ljava/lang/Iterable;", "pathText", "root", "Lcom/autonomousapps/graph/Node;", "sp", "Lcom/autonomousapps/graph/ShortestPath;", "toString", "dependency-analysis-gradle-plugin"})
final class NoReason
extends Reason {
    private final String adviceText = "There is no advice regarding this dependency.";
    private final Node root;
    private final ShortestPath sp;
    @NotNull
    private final Iterable<Edge> path;
    private final String pathText;
    private final String infoText;

    @Override
    @NotNull
    public Iterable<Edge> getPath() {
        return this.path;
    }

    @NotNull
    public String toString() {
        return this.getHeaderText() + ' ' + this.adviceText + "\n\n" + this.pathText + '\n' + this.infoText;
    }

    public NoReason(@NotNull DependencyGraph graph2, @NotNull ProducerNode queryNode) {
        Intrinsics.checkParameterIsNotNull((Object)graph2, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)queryNode, (String)"queryNode");
        super(queryNode, null);
        this.adviceText = "There is no advice regarding this dependency.";
        this.root = graph2.getRootNode();
        this.sp = new ShortestPath(graph2, this.root);
        Iterable<Edge> iterable = this.sp.pathTo(queryNode);
        if (iterable == null) {
            String string = "No path to node " + queryNode + ", violating invariant";
            NoReason noReason = this;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.path = iterable;
        this.pathText = PathPrinter.INSTANCE.printPath(this.getPath());
        this.infoText = NodePrinter.INSTANCE.print(queryNode);
    }
}

