/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.rest;

import android.text.TextUtils;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Oauth {
    public static final String TAG = "WordPressREST";
    public static final String AUTHORIZE_ENDPOINT = "https://public-api.wordpress.com/oauth2/authorize";
    private static final String AUTHORIZED_ENDPOINT_FORMAT = "%s?client_id=%s&redirect_uri=%s&response_type=code";
    public static final String TOKEN_ENDPOINT = "https://public-api.wordpress.com/oauth2/token";
    public static final String CLIENT_ID_PARAM_NAME = "client_id";
    public static final String REDIRECT_URI_PARAM_NAME = "redirect_uri";
    public static final String CLIENT_SECRET_PARAM_NAME = "client_secret";
    public static final String CODE_PARAM_NAME = "code";
    public static final String GRANT_TYPE_PARAM_NAME = "grant_type";
    public static final String USERNAME_PARAM_NAME = "username";
    public static final String PASSWORD_PARAM_NAME = "password";
    public static final String PASSWORD_GRANT_TYPE = "password";
    public static final String BEARER_GRANT_TYPE = "bearer";
    public static final String AUTHORIZATION_CODE_GRANT_TYPE = "authorization_code";
    private String mAppId;
    private String mAppSecret;
    private String mAppRedirectURI;

    public Oauth(String appId, String appSecret, String redirectURI) {
        this.mAppId = appId;
        this.mAppSecret = appSecret;
        this.mAppRedirectURI = redirectURI;
    }

    public String getAppID() {
        return this.mAppId;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public String getAppRedirectURI() {
        return this.mAppRedirectURI;
    }

    public String getAuthorizationURL() {
        return String.format(AUTHORIZED_ENDPOINT_FORMAT, AUTHORIZE_ENDPOINT, this.getAppID(), this.getAppRedirectURI());
    }

    public Request makeRequest(String username, String password, String twoStepCode, boolean shouldSendTwoStepSMS, Listener listener, ErrorListener errorListener) {
        return new PasswordRequest(this.getAppID(), this.getAppSecret(), this.getAppRedirectURI(), username, password, twoStepCode, shouldSendTwoStepSMS, listener, errorListener);
    }

    public Request makeRequest(String code, Listener listener, ErrorListener errorListener) {
        return new BearerRequest(this.getAppID(), this.getAppSecret(), this.getAppRedirectURI(), code, listener, errorListener);
    }

    public static class Token {
        private static final String TOKEN_TYPE_FIELD_NAME = "token_type";
        private static final String ACCESS_TOKEN_FIELD_NAME = "access_token";
        private static final String BLOG_URL_FIELD_NAME = "blog_url";
        private static final String SCOPE_FIELD_NAME = "scope";
        private static final String BLOG_ID_FIELD_NAME = "blog_id";
        private String mTokenType;
        private String mScope;
        private String mAccessToken;
        private String mBlogUrl;
        private String mBlogId;

        public Token(String accessToken, String blogUrl, String blogId, String scope, String tokenType) {
            this.mAccessToken = accessToken;
            this.mBlogUrl = blogUrl;
            this.mBlogId = blogId;
            this.mScope = scope;
            this.mTokenType = tokenType;
        }

        public String getAccessToken() {
            return this.mAccessToken;
        }

        public String toString() {
            return this.getAccessToken();
        }

        public static Token fromJSONObject(JSONObject tokenJSON) throws JSONException {
            return new Token(tokenJSON.getString(ACCESS_TOKEN_FIELD_NAME), tokenJSON.getString(BLOG_URL_FIELD_NAME), tokenJSON.getString(BLOG_ID_FIELD_NAME), tokenJSON.getString(SCOPE_FIELD_NAME), tokenJSON.getString(TOKEN_TYPE_FIELD_NAME));
        }
    }

    public static class BearerRequest
    extends Request {
        public BearerRequest(String appId, String appSecret, String redirectUri, String code, Listener listener, ErrorListener errorListener) {
            super(appId, appSecret, redirectUri, listener, errorListener);
            this.mParams.put(Oauth.CODE_PARAM_NAME, code);
            this.mParams.put(Oauth.GRANT_TYPE_PARAM_NAME, Oauth.BEARER_GRANT_TYPE);
        }
    }

    public static class PasswordRequest
    extends Request {
        public PasswordRequest(String appId, String appSecret, String redirectUri, String username, String password, String twoStepCode, boolean shouldSendTwoStepSMS, Listener listener, ErrorListener errorListener) {
            super(appId, appSecret, redirectUri, listener, errorListener);
            this.mParams.put(Oauth.USERNAME_PARAM_NAME, username);
            this.mParams.put("password", password);
            this.mParams.put(Oauth.GRANT_TYPE_PARAM_NAME, "password");
            if (!TextUtils.isEmpty((CharSequence)twoStepCode)) {
                this.mParams.put("wpcom_otp", twoStepCode);
            } else {
                this.mParams.put("wpcom_supports_2fa", "true");
                if (shouldSendTwoStepSMS) {
                    this.mParams.put("wpcom_resend_otp", "true");
                }
            }
        }
    }

    private static class Request
    extends com.android.volley.Request<Token> {
        private final Listener mListener;
        protected Map<String, String> mParams = new HashMap<String, String>();

        Request(String appId, String appSecret, String redirectUri, Listener listener, ErrorListener errorListener) {
            super(1, Oauth.TOKEN_ENDPOINT, (Response.ErrorListener)errorListener);
            this.mListener = listener;
            this.mParams.put(Oauth.CLIENT_ID_PARAM_NAME, appId);
            this.mParams.put(Oauth.CLIENT_SECRET_PARAM_NAME, appSecret);
            this.mParams.put(Oauth.REDIRECT_URI_PARAM_NAME, redirectUri);
        }

        public Map<String, String> getParams() {
            return this.mParams;
        }

        public void deliverResponse(Token token) {
            this.mListener.onResponse(token);
        }

        protected Response<Token> parseNetworkResponse(NetworkResponse response) {
            try {
                String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
                JSONObject tokenData = new JSONObject(jsonString);
                return Response.success((Object)Token.fromJSONObject(tokenData), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
            }
            catch (UnsupportedEncodingException e) {
                return Response.error((VolleyError)new ParseError((Throwable)e));
            }
            catch (JSONException je) {
                return Response.error((VolleyError)new ParseError((Throwable)je));
            }
        }
    }

    public static interface ErrorListener
    extends Response.ErrorListener {
    }

    public static interface Listener
    extends Response.Listener<Token> {
    }
}

