/*
 * Decompiled with CFR 0.152.
 */
package com.wordpress.rest;

import com.android.volley.Response;
import com.android.volley.VolleyLog;
import com.wordpress.rest.RestRequest;
import java.io.UnsupportedEncodingException;
import org.json.JSONObject;

public class JsonRestRequest
extends RestRequest {
    private static final String PROTOCOL_CHARSET = "utf-8";
    private static final String PROTOCOL_CONTENT_TYPE = String.format("application/json; charset=%s", "utf-8");
    private String mRequestBody;

    public JsonRestRequest(String url, JSONObject jsonRequest, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
        super(jsonRequest == null ? 0 : 1, url, null, listener, errorListener);
        if (jsonRequest != null) {
            this.mRequestBody = jsonRequest.toString();
        }
    }

    public String getBodyContentType() {
        return PROTOCOL_CONTENT_TYPE;
    }

    public byte[] getBody() {
        try {
            return this.mRequestBody == null ? null : this.mRequestBody.getBytes(PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            VolleyLog.wtf((String)"Unsupported Encoding while trying to get the bytes of %s using %s", (Object[])new Object[]{this.mRequestBody, PROTOCOL_CHARSET});
            return null;
        }
    }
}

