/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JobSvfOutputPayload {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="views")
    private List<ViewsEnum> views = new ArrayList<ViewsEnum>();

    public JobSvfOutputPayload type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The requested output types. Possible values include `svf`, `thumbnai`, `stl`, `step`, `iges`, or `obj`. For a list of supported types, call the [GET formats](https://developer.autodesk.com/en/docs/model-derivative/v2/reference/http/formats-GET) endpoint.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public JobSvfOutputPayload views(List<ViewsEnum> views) {
        this.views = views;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<ViewsEnum> getViews() {
        return this.views;
    }

    public void setViews(List<ViewsEnum> views) {
        this.views = views;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobSvfOutputPayload jobSvfOutputPayload = (JobSvfOutputPayload)o;
        return Objects.equals((Object)this.type, (Object)jobSvfOutputPayload.type) && Objects.equals(this.views, jobSvfOutputPayload.views);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.views});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobSvfOutputPayload {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    views: ").append(this.toIndentedString(this.views)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ViewsEnum {
        _2D("2d"),
        _3D("3d");

        private String value;

        private ViewsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        SVF("svf"),
        IFC("ifc"),
        THUMBNAIL("thumbnail"),
        STL("stl"),
        STEP("step"),
        IGES("iges"),
        OBJ("obj");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

