/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.autodesk.client.model.JobObjOutputPayloadAdvanced;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Output description object, depends of the type")
public class JobPayloadItem {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="views")
    private List<ViewsEnum> views = new ArrayList<ViewsEnum>();
    @JsonProperty(value="advanced")
    private JobObjOutputPayloadAdvanced advanced = null;

    public JobPayloadItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The requested output types. Possible values include `svf`, `thumbnai`, `stl`, `step`, `iges`, or `obj`. For a list of supported types, call the [GET formats](https://developer.autodesk.com/en/docs/model-derivative/v2/reference/http/formats-GET) endpoint.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public JobPayloadItem views(List<ViewsEnum> views) {
        this.views = views;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<ViewsEnum> getViews() {
        return this.views;
    }

    public void setViews(List<ViewsEnum> views) {
        this.views = views;
    }

    public JobPayloadItem advanced(JobObjOutputPayloadAdvanced advanced) {
        this.advanced = advanced;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public JobObjOutputPayloadAdvanced getAdvanced() {
        return this.advanced;
    }

    public void setAdvanced(JobObjOutputPayloadAdvanced advanced) {
        this.advanced = advanced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPayloadItem jobPayloadItem = (JobPayloadItem)o;
        return Objects.equals((Object)this.type, (Object)jobPayloadItem.type) && Objects.equals(this.views, jobPayloadItem.views) && Objects.equals(this.advanced, jobPayloadItem.advanced);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.views, this.advanced});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobPayloadItem {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    views: ").append(this.toIndentedString(this.views)).append("\n");
        sb.append("    advanced: ").append(this.toIndentedString(this.advanced)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ViewsEnum {
        _2D("2d"),
        _3D("3d");

        private String value;

        private ViewsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        SVF("svf"),
        RVT("rvt"),
        IFC("ifc"),
        THUMBNAIL("thumbnail"),
        STL("stl"),
        STEP("step"),
        IGES("iges"),
        OBJ("obj");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

