/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.CreateStorage;
import com.autodesk.client.model.CreateVersion;
import com.autodesk.client.model.Hub;
import com.autodesk.client.model.Project;
import com.autodesk.client.model.Projects;
import com.autodesk.client.model.StorageCreated;
import com.autodesk.client.model.VersionCreated;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProjectsApi {
    private ApiClient apiClient;

    public ProjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProjectsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Projects> getHubProjects(String hubId, List<String> filterId, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (hubId == null) {
            throw new ApiException(400, "Missing the required parameter 'hubId' when calling getHubProjects");
        }
        String localVarPath = "/project/v1/hubs/{hub_id}/projects".replaceAll("\\{format\\}", "json").replaceAll("\\{hub_id\\}", this.apiClient.escapeString(hubId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Projects> localVarReturnType = new GenericType<Projects>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Project> getProject(String hubId, String projectId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (hubId == null) {
            throw new ApiException(400, "Missing the required parameter 'hubId' when calling getProject");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getProject");
        }
        String localVarPath = "/project/v1/hubs/{hub_id}/projects/{project_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{hub_id\\}", this.apiClient.escapeString(hubId.toString())).replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Project> localVarReturnType = new GenericType<Project>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Hub> getProjectHub(String hubId, String projectId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (hubId == null) {
            throw new ApiException(400, "Missing the required parameter 'hubId' when calling getProjectHub");
        }
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getProjectHub");
        }
        String localVarPath = "/project/v1/hubs/{hub_id}/projects/{project_id}/hub".replaceAll("\\{format\\}", "json").replaceAll("\\{hub_id\\}", this.apiClient.escapeString(hubId.toString())).replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Hub> localVarReturnType = new GenericType<Hub>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<StorageCreated> postStorage(String projectId, CreateStorage body, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        CreateStorage localVarPostBody = body;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling postStorage");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postStorage");
        }
        String localVarPath = "/data/v1/projects/{project_id}/storage".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<StorageCreated> localVarReturnType = new GenericType<StorageCreated>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<VersionCreated> postVersion(String projectId, CreateVersion body, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        CreateVersion localVarPostBody = body;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling postVersion");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postVersion");
        }
        String localVarPath = "/data/v1/projects/{project_id}/versions".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<VersionCreated> localVarReturnType = new GenericType<VersionCreated>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }
}

