/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.CreateItem;
import com.autodesk.client.model.CreateRef;
import com.autodesk.client.model.Folder;
import com.autodesk.client.model.Item;
import com.autodesk.client.model.ItemCreated;
import com.autodesk.client.model.JsonApiCollection;
import com.autodesk.client.model.Refs;
import com.autodesk.client.model.Version;
import com.autodesk.client.model.Versions;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ItemsApi {
    private ApiClient apiClient;

    public ItemsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ItemsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Item> getItem(String projectId, String itemId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getItem");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling getItem");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items/{item_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Item> localVarReturnType = new GenericType<Item>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Folder> getItemParentFolder(String projectId, String itemId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getItemParentFolder");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling getItemParentFolder");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items/{item_id}/parent".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Folder> localVarReturnType = new GenericType<Folder>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<JsonApiCollection> getItemRefs(String projectId, String itemId, List<String> filterType, List<String> filterId, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getItemRefs");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling getItemRefs");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items/{item_id}/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<JsonApiCollection> localVarReturnType = new GenericType<JsonApiCollection>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Refs> getItemRelationshipsRefs(String projectId, String itemId, List<String> filterType, List<String> filterId, List<String> filterRefType, String filterDirection, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getItemRelationshipsRefs");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling getItemRelationshipsRefs");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items/{item_id}/relationships/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[refType]", filterRefType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[direction]", filterDirection));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Refs> localVarReturnType = new GenericType<Refs>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Version> getItemTip(String projectId, String itemId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getItemTip");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling getItemTip");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items/{item_id}/tip".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Version> localVarReturnType = new GenericType<Version>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Versions> getItemVersions(String projectId, String itemId, List<String> filterType, List<String> filterId, List<String> filterExtensionType, List<Integer> filterVersionNumber, Integer pageNumber, Integer pageLimit, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getItemVersions");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling getItemVersions");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items/{item_id}/versions".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[versionNumber]", filterVersionNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Versions> localVarReturnType = new GenericType<Versions>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<ItemCreated> postItem(String projectId, CreateItem body, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        CreateItem localVarPostBody = body;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling postItem");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postItem");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<ItemCreated> localVarReturnType = new GenericType<ItemCreated>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> postItemRelationshipsRef(String projectId, String itemId, CreateRef body, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        CreateRef localVarPostBody = body;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling postItemRelationshipsRef");
        }
        if (itemId == null) {
            throw new ApiException(400, "Missing the required parameter 'itemId' when calling postItemRelationshipsRef");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postItemRelationshipsRef");
        }
        String localVarPath = "/data/v1/projects/{project_id}/items/{item_id}/relationships/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{item_id\\}", this.apiClient.escapeString(itemId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }
}

