/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Group of inputs")
public class JobPayloadInput {
    @JsonProperty(value="urn")
    private String urn = null;
    @JsonProperty(value="compressedUrn")
    private Boolean compressedUrn = false;
    @JsonProperty(value="rootFilename")
    private String rootFilename = null;

    public JobPayloadInput urn(String urn) {
        this.urn = urn;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The design URN; returned when uploading the file to Forge The URN needs to be [Base64 (URL Safe) encoded](https://developer.autodesk.com/en/docs/model-derivative/v2/reference/http/job-POST/#id3). ")
    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public JobPayloadInput compressedUrn(Boolean compressedUrn) {
        this.compressedUrn = compressedUrn;
        return this;
    }

    @ApiModelProperty(example="null", value="Set this to `true` if the source file is compressed. If set to `true`, you need to define the `rootFilename`.")
    public Boolean getCompressedUrn() {
        return this.compressedUrn;
    }

    public void setCompressedUrn(Boolean compressedUrn) {
        this.compressedUrn = compressedUrn;
    }

    public JobPayloadInput rootFilename(String rootFilename) {
        this.rootFilename = rootFilename;
        return this;
    }

    @ApiModelProperty(example="null", value="The root filename of the compressed file. Mandatory if the `compressedUrn` is set to `true`.")
    public String getRootFilename() {
        return this.rootFilename;
    }

    public void setRootFilename(String rootFilename) {
        this.rootFilename = rootFilename;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobPayloadInput jobPayloadInput = (JobPayloadInput)o;
        return Objects.equals(this.urn, jobPayloadInput.urn) && Objects.equals(this.compressedUrn, jobPayloadInput.compressedUrn) && Objects.equals(this.rootFilename, jobPayloadInput.rootFilename);
    }

    public int hashCode() {
        return Objects.hash(this.urn, this.compressedUrn, this.rootFilename);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobPayloadInput {\n");
        sb.append("    urn: ").append(this.toIndentedString(this.urn)).append("\n");
        sb.append("    compressedUrn: ").append(this.toIndentedString(this.compressedUrn)).append("\n");
        sb.append("    rootFilename: ").append(this.toIndentedString(this.rootFilename)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

