/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.CreateRef;
import com.autodesk.client.model.Item;
import com.autodesk.client.model.JsonApiCollection;
import com.autodesk.client.model.Refs;
import com.autodesk.client.model.Version;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VersionsApi {
    private ApiClient apiClient;

    public VersionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VersionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Version> getVersion(String projectId, String versionId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getVersion");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getVersion");
        }
        String localVarPath = "/data/v1/projects/{project_id}/versions/{version_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{version_id\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Version> localVarReturnType = new GenericType<Version>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Item> getVersionItem(String projectId, String versionId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getVersionItem");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getVersionItem");
        }
        String localVarPath = "/data/v1/projects/{project_id}/versions/{version_id}/item".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{version_id\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Item> localVarReturnType = new GenericType<Item>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<JsonApiCollection> getVersionRefs(String projectId, String versionId, List<String> filterType, List<String> filterId, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getVersionRefs");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getVersionRefs");
        }
        String localVarPath = "/data/v1/projects/{project_id}/versions/{version_id}/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{version_id\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<JsonApiCollection> localVarReturnType = new GenericType<JsonApiCollection>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Refs> getVersionRelationshipsRefs(String projectId, String versionId, List<String> filterType, List<String> filterId, List<String> filterRefType, String filterDirection, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getVersionRelationshipsRefs");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling getVersionRelationshipsRefs");
        }
        String localVarPath = "/data/v1/projects/{project_id}/versions/{version_id}/relationships/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{version_id\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[refType]", filterRefType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[direction]", filterDirection));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Refs> localVarReturnType = new GenericType<Refs>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> postVersionRelationshipsRef(String projectId, String versionId, CreateRef body, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        CreateRef localVarPostBody = body;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling postVersionRelationshipsRef");
        }
        if (versionId == null) {
            throw new ApiException(400, "Missing the required parameter 'versionId' when calling postVersionRelationshipsRef");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postVersionRelationshipsRef");
        }
        String localVarPath = "/data/v1/projects/{project_id}/versions/{version_id}/relationships/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{version_id\\}", this.apiClient.escapeString(versionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }
}

