/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.CreateRef;
import com.autodesk.client.model.Folder;
import com.autodesk.client.model.JsonApiCollection;
import com.autodesk.client.model.Refs;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FoldersApi {
    private ApiClient apiClient;

    public FoldersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FoldersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Folder> getFolder(String projectId, String folderId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getFolder");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolder");
        }
        String localVarPath = "/data/v1/projects/{project_id}/folders/{folder_id}".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{folder_id\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Folder> localVarReturnType = new GenericType<Folder>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<JsonApiCollection> getFolderContents(String projectId, String folderId, List<String> filterType, List<String> filterId, List<String> filterExtensionType, Integer pageNumber, Integer pageLimit, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getFolderContents");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolderContents");
        }
        String localVarPath = "/data/v1/projects/{project_id}/folders/{folder_id}/contents".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{folder_id\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<JsonApiCollection> localVarReturnType = new GenericType<JsonApiCollection>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Folder> getFolderParent(String projectId, String folderId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getFolderParent");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolderParent");
        }
        String localVarPath = "/data/v1/projects/{project_id}/folders/{folder_id}/parent".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{folder_id\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Folder> localVarReturnType = new GenericType<Folder>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<JsonApiCollection> getFolderRefs(String projectId, String folderId, List<String> filterType, List<String> filterId, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getFolderRefs");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolderRefs");
        }
        String localVarPath = "/data/v1/projects/{project_id}/folders/{folder_id}/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{folder_id\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<JsonApiCollection> localVarReturnType = new GenericType<JsonApiCollection>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Refs> getFolderRelationshipsRefs(String projectId, String folderId, List<String> filterType, List<String> filterId, List<String> filterRefType, String filterDirection, List<String> filterExtensionType, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getFolderRelationshipsRefs");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolderRelationshipsRefs");
        }
        String localVarPath = "/data/v1/projects/{project_id}/folders/{folder_id}/relationships/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{folder_id\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[id]", filterId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[refType]", filterRefType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[direction]", filterDirection));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("csv", "filter[extension.type]", filterExtensionType));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Refs> localVarReturnType = new GenericType<Refs>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> postFolderRelationshipsRef(String projectId, String folderId, CreateRef body, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        CreateRef localVarPostBody = body;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling postFolderRelationshipsRef");
        }
        if (folderId == null) {
            throw new ApiException(400, "Missing the required parameter 'folderId' when calling postFolderRelationshipsRef");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling postFolderRelationshipsRef");
        }
        String localVarPath = "/data/v1/projects/{project_id}/folders/{folder_id}/relationships/refs".replaceAll("\\{format\\}", "json").replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString())).replaceAll("\\{folder_id\\}", this.apiClient.escapeString(folderId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.api+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }
}

