/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.Bucket;
import com.autodesk.client.model.Buckets;
import com.autodesk.client.model.PostBucketsPayload;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class BucketsApi {
    private ApiClient apiClient;

    public BucketsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BucketsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<Bucket> createBucket(PostBucketsPayload postBuckets, String xAdsRegion, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        PostBucketsPayload localVarPostBody = postBuckets;
        if (postBuckets == null) {
            throw new ApiException(400, "Missing the required parameter 'postBuckets' when calling createBucket");
        }
        String localVarPath = "/oss/v2/buckets".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xAdsRegion != null) {
            localVarHeaderParams.put("x-ads-region", this.apiClient.parameterToString(xAdsRegion));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Bucket> localVarReturnType = new GenericType<Bucket>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> deleteBucket(String bucketKey, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling deleteBucket");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<Bucket> getBucketDetails(String bucketKey, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getBucketDetails");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/details".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Bucket> localVarReturnType = new GenericType<Bucket>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Buckets> getBuckets(String region, Integer limit, String startAt, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        String localVarPath = "/oss/v2/buckets".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "region", region));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startAt", startAt));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<Buckets> localVarReturnType = new GenericType<Buckets>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }
}

