/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client;

import com.autodesk.client.Pair;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringUtil {
    public static boolean containsIgnoreCase(String[] array, String value) {
        for (String str : array) {
            if (value == null && str == null) {
                return true;
            }
            if (value == null || !value.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    public static String join(String[] array, String separator) {
        int len = array.length;
        if (len == 0) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append(array[0]);
        for (int i = 1; i < len; ++i) {
            out.append(separator).append(array[i]);
        }
        return out.toString();
    }

    public static class JacksonMapper {
        private static final ObjectMapper mapper = new ObjectMapper();
        private static final JacksonMapper INSTANCE = new JacksonMapper();

        private JacksonMapper() {
        }

        public static JacksonMapper getInstance() {
            return INSTANCE;
        }

        public Map<String, String> toMap(String jsonString) throws Exception {
            return (Map)mapper.readValue(jsonString, (TypeReference)new TypeReference<HashMap<String, String>>(){});
        }

        public List<Pair> toListPair(String jsonString) throws Exception {
            ArrayList<Pair> list = new ArrayList<Pair>();
            Map<String, String> map = this.toMap(jsonString);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                list.add(new Pair(entry.getKey(), entry.getValue()));
            }
            return list;
        }
    }
}

