/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.autodesk.client.model.BaseAttributesExtensionObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * VersionAttributes
 */

public class VersionAttributes   {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("versionNumber")
  private Integer versionNumber = null;

  @JsonProperty("mimeType")
  private String mimeType = null;

  @JsonProperty("fileType")
  private String fileType = null;

  @JsonProperty("storageSize")
  private Long storageSize = null;

  @JsonProperty("extension")
  private BaseAttributesExtensionObject extension = null;
  
  //add more attributes for response
  @JsonProperty("createTime")
  private String createTime = null;
  
  @JsonProperty("createUserId")
  private String createUserId = null;
  
  @JsonProperty("createUserName")
  private String createUserName = null;
  
  @JsonProperty("lastModifiedTime")
  private String lastModifiedTime = null;
  
  @JsonProperty("lastModifiedUserId")
  private String lastModifiedUserId = null;

  @JsonProperty("lastModifiedUserName")
  private String lastModifiedUserName = null;
   
  
  public VersionAttributes name(String name) {
    this.name = name;
    return this;
  }

   /**
   * filename used when synced to local disk
   * @return name
  **/
  @ApiModelProperty(example = "null", required = true, value = "filename used when synced to local disk")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public VersionAttributes displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * displayable name of the version
   * @return displayName
  **/
  @ApiModelProperty(example = "null", required = true, value = "displayable name of the version")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public VersionAttributes versionNumber(Integer versionNumber) {
    this.versionNumber = versionNumber;
    return this;
  }

   /**
   * version number of this version
   * @return versionNumber
  **/
  @ApiModelProperty(example = "null", required = true, value = "version number of this version")
  public Integer getVersionNumber() {
    return versionNumber;
  }

  public void setVersionNumber(Integer versionNumber) {
    this.versionNumber = versionNumber;
  }

  public VersionAttributes mimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

   /**
   * mimetype of the version`s content
   * @return mimeType
  **/
  @ApiModelProperty(example = "null", value = "mimetype of the version`s content")
  public String getMimeType() {
    return mimeType;
  }

  public void setMimeType(String mimeType) {
    this.mimeType = mimeType;
  }

  public VersionAttributes fileType(String fileType) {
    this.fileType = fileType;
    return this;
  }

   /**
   * file type, only present if this version represents a file
   * @return fileType
  **/
  @ApiModelProperty(example = "null", value = "file type, only present if this version represents a file")
  public String getFileType() {
    return fileType;
  }

  public void setFileType(String fileType) {
    this.fileType = fileType;
  }

  public VersionAttributes storageSize(Long storageSize) {
    this.storageSize = storageSize;
    return this;
  }

   /**
   * file size in bytes, only present if this version represents a file
   * @return storageSize
  **/
  @ApiModelProperty(example = "null", value = "file size in bytes, only present if this version represents a file")
  public Long getStorageSize() {
    return storageSize;
  }

  public void setStorageSize(Long storageSize) {
    this.storageSize = storageSize;
  }

  public VersionAttributes extension(BaseAttributesExtensionObject extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public BaseAttributesExtensionObject getExtension() {
    return extension;
  }

  public void setExtension(BaseAttributesExtensionObject extension) {
    this.extension = extension;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VersionAttributes versionAttributes = (VersionAttributes) o;
    return Objects.equals(this.name, versionAttributes.name) &&
        Objects.equals(this.displayName, versionAttributes.displayName) &&
        Objects.equals(this.versionNumber, versionAttributes.versionNumber) &&
        Objects.equals(this.mimeType, versionAttributes.mimeType) &&
        Objects.equals(this.fileType, versionAttributes.fileType) &&
        Objects.equals(this.storageSize, versionAttributes.storageSize) &&
        Objects.equals(this.extension, versionAttributes.extension);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, displayName, versionNumber, mimeType, fileType, storageSize, extension);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VersionAttributes {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    versionNumber: ").append(toIndentedString(versionNumber)).append("\n");
    sb.append("    mimeType: ").append(toIndentedString(mimeType)).append("\n");
    sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
    sb.append("    storageSize: ").append(toIndentedString(storageSize)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
} 