/**
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. From visualizing data to 3D printing, take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;
import com.autodesk.client.model.Mesh;
import com.autodesk.client.model.TaskError;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;


/**
 * Task
 */

public class Task   {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("progress")
  private BigDecimal progress = null;

  @JsonProperty("result")
  private Mesh result = null;

  @JsonProperty("error")
  private TaskError error = null;

  public Task id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Task ID
   * @return id
  **/
  @ApiModelProperty(example = "null", value = "Task ID")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Task status(String status) {
    this.status = status;
    return this;
  }

   /**
   * Possible values: running, done, and error
   * @return status
  **/
  @ApiModelProperty(example = "null", value = "Possible values: running, done, and error")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public Task progress(BigDecimal progress) {
    this.progress = progress;
    return this;
  }

   /**
   * A value between 0 (not started) and 1 (complete) indicating percentage complete
   * @return progress
  **/
  @ApiModelProperty(example = "null", value = "A value between 0 (not started) and 1 (complete) indicating percentage complete")
  public BigDecimal getProgress() {
    return progress;
  }

  public void setProgress(BigDecimal progress) {
    this.progress = progress;
  }

  public Task result(Mesh result) {
    this.result = result;
    return this;
  }

   /**
   * The response if status is done
   * @return result
  **/
  @ApiModelProperty(example = "null", value = "The response if status is done")
  public Mesh getResult() {
    return result;
  }

  public void setResult(Mesh result) {
    this.result = result;
  }

  public Task error(TaskError error) {
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @ApiModelProperty(example = "null", value = "")
  public TaskError getError() {
    return error;
  }

  public void setError(TaskError error) {
    this.error = error;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Task task = (Task) o;
    return Objects.equals(this.id, task.id) &&
        Objects.equals(this.status, task.status) &&
        Objects.equals(this.progress, task.progress) &&
        Objects.equals(this.result, task.result) &&
        Objects.equals(this.error, task.error);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, status, progress, result, error);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Task {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    progress: ").append(toIndentedString(progress)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

