/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.autodesk.client.model.BaseAttributesExtensionObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * RelRefMeta
 */

public class RelRefMeta   {
  /**
   * Gets or Sets refType
   */
  public enum RefTypeEnum {
    DERIVED("derived"),
    
    DEPENDENCIES("dependencies"),
    
    AUXILIARY("auxiliary"),
    
    XREFS("xrefs");

    private String value;

    RefTypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("refType")
  private RefTypeEnum refType = null;

  /**
   * describes the direction of the reference relative to the resource the refs are queried for
   */
  public enum DirectionEnum {
    FROM("from"),
    
    TO("to");

    private String value;

    DirectionEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("direction")
  private DirectionEnum direction = null;

  @JsonProperty("fromId")
  private String fromId = null;

  /**
   * Gets or Sets fromType
   */
  public enum FromTypeEnum {
    FOLDERS("folders"),
    
    ITEMS("items"),
    
    VERSIONS("versions");

    private String value;

    FromTypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("fromType")
  private FromTypeEnum fromType = null;

  @JsonProperty("toId")
  private String toId = null;

  /**
   * Gets or Sets toType
   */
  public enum ToTypeEnum {
    FOLDERS("folders"),
    
    ITEMS("items"),
    
    VERSIONS("versions");

    private String value;

    ToTypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("toType")
  private ToTypeEnum toType = null;

  @JsonProperty("extension")
  private BaseAttributesExtensionObject extension = null;

  public RelRefMeta refType(RefTypeEnum refType) {
    this.refType = refType;
    return this;
  }

   /**
   * Get refType
   * @return refType
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public RefTypeEnum getRefType() {
    return refType;
  }

  public void setRefType(RefTypeEnum refType) {
    this.refType = refType;
  }

  public RelRefMeta direction(DirectionEnum direction) {
    this.direction = direction;
    return this;
  }

   /**
   * describes the direction of the reference relative to the resource the refs are queried for
   * @return direction
  **/
  @ApiModelProperty(example = "null", required = true, value = "describes the direction of the reference relative to the resource the refs are queried for")
  public DirectionEnum getDirection() {
    return direction;
  }

  public void setDirection(DirectionEnum direction) {
    this.direction = direction;
  }

  public RelRefMeta fromId(String fromId) {
    this.fromId = fromId;
    return this;
  }

   /**
   * Get fromId
   * @return fromId
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public String getFromId() {
    return fromId;
  }

  public void setFromId(String fromId) {
    this.fromId = fromId;
  }

  public RelRefMeta fromType(FromTypeEnum fromType) {
    this.fromType = fromType;
    return this;
  }

   /**
   * Get fromType
   * @return fromType
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public FromTypeEnum getFromType() {
    return fromType;
  }

  public void setFromType(FromTypeEnum fromType) {
    this.fromType = fromType;
  }

  public RelRefMeta toId(String toId) {
    this.toId = toId;
    return this;
  }

   /**
   * Get toId
   * @return toId
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public String getToId() {
    return toId;
  }

  public void setToId(String toId) {
    this.toId = toId;
  }

  public RelRefMeta toType(ToTypeEnum toType) {
    this.toType = toType;
    return this;
  }

   /**
   * Get toType
   * @return toType
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public ToTypeEnum getToType() {
    return toType;
  }

  public void setToType(ToTypeEnum toType) {
    this.toType = toType;
  }

  public RelRefMeta extension(BaseAttributesExtensionObject extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public BaseAttributesExtensionObject getExtension() {
    return extension;
  }

  public void setExtension(BaseAttributesExtensionObject extension) {
    this.extension = extension;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RelRefMeta relRefMeta = (RelRefMeta) o;
    return Objects.equals(this.refType, relRefMeta.refType) &&
        Objects.equals(this.direction, relRefMeta.direction) &&
        Objects.equals(this.fromId, relRefMeta.fromId) &&
        Objects.equals(this.fromType, relRefMeta.fromType) &&
        Objects.equals(this.toId, relRefMeta.toId) &&
        Objects.equals(this.toType, relRefMeta.toType) &&
        Objects.equals(this.extension, relRefMeta.extension);
  }

  @Override
  public int hashCode() {
    return Objects.hash(refType, direction, fromId, fromType, toId, toType, extension);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RelRefMeta {\n");
    
    sb.append("    refType: ").append(toIndentedString(refType)).append("\n");
    sb.append("    direction: ").append(toIndentedString(direction)).append("\n");
    sb.append("    fromId: ").append(toIndentedString(fromId)).append("\n");
    sb.append("    fromType: ").append(toIndentedString(fromType)).append("\n");
    sb.append("    toId: ").append(toIndentedString(toId)).append("\n");
    sb.append("    toType: ").append(toIndentedString(toType)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

