/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.autodesk.client.model.MetadataObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;


/**
 * metadata object definition
 */
@ApiModel(description = "metadata object definition")

public class MetadataObject   {
  @JsonProperty("objectid")
  private Integer objectid = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("objects")
  private List<MetadataObject> objects = new ArrayList<MetadataObject>();

  public MetadataObject objectid(Integer objectid) {
    this.objectid = objectid;
    return this;
  }

   /**
   * Unique ID for the object
   * @return objectid
  **/
  @ApiModelProperty(example = "null", required = true, value = "Unique ID for the object")
  public Integer getObjectid() {
    return objectid;
  }

  public void setObjectid(Integer objectid) {
    this.objectid = objectid;
  }

  public MetadataObject name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Name of the object
   * @return name
  **/
  @ApiModelProperty(example = "null", required = true, value = "Name of the object")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public MetadataObject objects(List<MetadataObject> objects) {
    this.objects = objects;
    return this;
  }

   /**
   * Optional collection of “children” objects within the hierarchy
   * @return objects
  **/
  @ApiModelProperty(example = "null", value = "Optional collection of “children” objects within the hierarchy")
  public List<MetadataObject> getObjects() {
    return objects;
  }

  public void setObjects(List<MetadataObject> objects) {
    this.objects = objects;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MetadataObject metadataObject = (MetadataObject) o;
    return Objects.equals(this.objectid, metadataObject.objectid) &&
        Objects.equals(this.name, metadataObject.name) &&
        Objects.equals(this.objects, metadataObject.objects);
  }

  @Override
  public int hashCode() {
    return Objects.hash(objectid, name, objects);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MetadataObject {\n");
    
    sb.append("    objectid: ").append(toIndentedString(objectid)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    objects: ").append(toIndentedString(objects)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

