/**
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. From visualizing data to 3D printing, take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;
import com.autodesk.client.model.MeshGeomBoundingBox;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * MeshGeom
 */

public class MeshGeom   {
  @JsonProperty("num_vertices")
  private Integer numVertices = null;

  @JsonProperty("num_triangles")
  private Integer numTriangles = null;

  @JsonProperty("has_uvs")
  private Boolean hasUvs = null;

  @JsonProperty("bounding_box")
  private MeshGeomBoundingBox boundingBox = null;

  public MeshGeom numVertices(Integer numVertices) {
    this.numVertices = numVertices;
    return this;
  }

   /**
   * Get numVertices
   * @return numVertices
  **/
  @ApiModelProperty(example = "null", value = "")
  public Integer getNumVertices() {
    return numVertices;
  }

  public void setNumVertices(Integer numVertices) {
    this.numVertices = numVertices;
  }

  public MeshGeom numTriangles(Integer numTriangles) {
    this.numTriangles = numTriangles;
    return this;
  }

   /**
   * Get numTriangles
   * @return numTriangles
  **/
  @ApiModelProperty(example = "null", value = "")
  public Integer getNumTriangles() {
    return numTriangles;
  }

  public void setNumTriangles(Integer numTriangles) {
    this.numTriangles = numTriangles;
  }

  public MeshGeom hasUvs(Boolean hasUvs) {
    this.hasUvs = hasUvs;
    return this;
  }

   /**
   * Get hasUvs
   * @return hasUvs
  **/
  @ApiModelProperty(example = "null", value = "")
  public Boolean getHasUvs() {
    return hasUvs;
  }

  public void setHasUvs(Boolean hasUvs) {
    this.hasUvs = hasUvs;
  }

  public MeshGeom boundingBox(MeshGeomBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
    return this;
  }

   /**
   * Get boundingBox
   * @return boundingBox
  **/
  @ApiModelProperty(example = "null", value = "")
  public MeshGeomBoundingBox getBoundingBox() {
    return boundingBox;
  }

  public void setBoundingBox(MeshGeomBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MeshGeom meshGeom = (MeshGeom) o;
    return Objects.equals(this.numVertices, meshGeom.numVertices) &&
        Objects.equals(this.numTriangles, meshGeom.numTriangles) &&
        Objects.equals(this.hasUvs, meshGeom.hasUvs) &&
        Objects.equals(this.boundingBox, meshGeom.boundingBox);
  }

  @Override
  public int hashCode() {
    return Objects.hash(numVertices, numTriangles, hasUvs, boundingBox);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MeshGeom {\n");
    
    sb.append("    numVertices: ").append(toIndentedString(numVertices)).append("\n");
    sb.append("    numTriangles: ").append(toIndentedString(numTriangles)).append("\n");
    sb.append("    hasUvs: ").append(toIndentedString(hasUvs)).append("\n");
    sb.append("    boundingBox: ").append(toIndentedString(boundingBox)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

