/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.autodesk.client.model.ManifestChildren;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;


/**
 * Requested output files for the source file URN
 */
@ApiModel(description = "Requested output files for the source file URN")

public class ManifestDerivative   {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("hasThumbnail")
  private Boolean hasThumbnail = null;

  /**
   * Gets or Sets outputType
   */
  public enum OutputTypeEnum {
    STL("stl"),
    
    IFC("ifc"),

    STEP("step"),
    
    IGES("iges"),
    
    OBJ("obj"),
    
    SVF("svf"),
    
    THUMBNAIL("thumbnail");

    private String value;

    OutputTypeEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("outputType")
  private OutputTypeEnum outputType = null;

  @JsonProperty("progress")
  private String progress = null;

  /**
   * Status of the requested entity; possible values are: `pending`, `success`, `inprogress`, `failed`, `timeout` and `partialsuccess` 
   */
  public enum StatusEnum {
    PENDING("pending"),
    
    INPROGRESS("inprogress"),
    
    SUCCESS("success"),
    
    FAILED("failed"),
    
    TIMEOUT("timeout"),
    
    PARTIALSUCCESS("partialsuccess");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("status")
  private StatusEnum status = null;

  @JsonProperty("children")
  private List<ManifestChildren> children = new ArrayList<ManifestChildren>();

  public ManifestDerivative name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Output file type
   * @return name
  **/
  @ApiModelProperty(example = "null", required = true, value = "Output file type")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ManifestDerivative hasThumbnail(Boolean hasThumbnail) {
    this.hasThumbnail = hasThumbnail;
    return this;
  }

   /**
   * Indicates if a thumbnail has been generated
   * @return hasThumbnail
  **/
  @ApiModelProperty(example = "null", required = true, value = "Indicates if a thumbnail has been generated")
  public Boolean getHasThumbnail() {
    return hasThumbnail;
  }

  public void setHasThumbnail(Boolean hasThumbnail) {
    this.hasThumbnail = hasThumbnail;
  }

  public ManifestDerivative outputType(OutputTypeEnum outputType) {
    this.outputType = outputType;
    return this;
  }

   /**
   * Get outputType
   * @return outputType
  **/
  @ApiModelProperty(example = "null", value = "")
  public OutputTypeEnum getOutputType() {
    return outputType;
  }

  public void setOutputType(OutputTypeEnum outputType) {
    this.outputType = outputType;
  }

  public ManifestDerivative progress(String progress) {
    this.progress = progress;
    return this;
  }

   /**
   * Translation progress for requested entity
   * @return progress
  **/
  @ApiModelProperty(example = "null", required = true, value = "Translation progress for requested entity")
  public String getProgress() {
    return progress;
  }

  public void setProgress(String progress) {
    this.progress = progress;
  }

  public ManifestDerivative status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * Status of the requested entity; possible values are: `pending`, `success`, `inprogress`, `failed`, `timeout` and `partialsuccess` 
   * @return status
  **/
  @ApiModelProperty(example = "null", required = true, value = "Status of the requested entity; possible values are: `pending`, `success`, `inprogress`, `failed`, `timeout` and `partialsuccess` ")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public ManifestDerivative children(List<ManifestChildren> children) {
    this.children = children;
    return this;
  }

   /**
   * Get children
   * @return children
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public List<ManifestChildren> getChildren() {
    return children;
  }

  public void setChildren(List<ManifestChildren> children) {
    this.children = children;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ManifestDerivative manifestDerivative = (ManifestDerivative) o;
    return Objects.equals(this.name, manifestDerivative.name) &&
        Objects.equals(this.hasThumbnail, manifestDerivative.hasThumbnail) &&
        Objects.equals(this.outputType, manifestDerivative.outputType) &&
        Objects.equals(this.progress, manifestDerivative.progress) &&
        Objects.equals(this.status, manifestDerivative.status) &&
        Objects.equals(this.children, manifestDerivative.children);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, hasThumbnail, outputType, progress, status, children);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ManifestDerivative {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    hasThumbnail: ").append(toIndentedString(hasThumbnail)).append("\n");
    sb.append("    outputType: ").append(toIndentedString(outputType)).append("\n");
    sb.append("    progress: ").append(toIndentedString(progress)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

