/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * Group of inputs
 */
@ApiModel(description = "Group of inputs")

public class JobPayloadInput   {
  @JsonProperty("urn")
  private String urn = null;

  @JsonProperty("compressedUrn")
  private Boolean compressedUrn = false;

  @JsonProperty("rootFilename")
  private String rootFilename = null;

  public JobPayloadInput urn(String urn) {
    this.urn = urn;
    return this;
  }

   /**
   * The design URN; returned when uploading the file to Forge The URN needs to be [Base64 (URL Safe) encoded](https://developer.autodesk.com/en/docs/model-derivative/v2/reference/http/job-POST/#id3). 
   * @return urn
  **/
  @ApiModelProperty(example = "null", required = true, value = "The design URN; returned when uploading the file to Forge The URN needs to be [Base64 (URL Safe) encoded](https://developer.autodesk.com/en/docs/model-derivative/v2/reference/http/job-POST/#id3). ")
  public String getUrn() {
    return urn;
  }

  public void setUrn(String urn) {
    this.urn = urn;
  }

  public JobPayloadInput compressedUrn(Boolean compressedUrn) {
    this.compressedUrn = compressedUrn;
    return this;
  }

   /**
   * Set this to `true` if the source file is compressed. If set to `true`, you need to define the `rootFilename`.
   * @return compressedUrn
  **/
  @ApiModelProperty(example = "null", value = "Set this to `true` if the source file is compressed. If set to `true`, you need to define the `rootFilename`.")
  public Boolean getCompressedUrn() {
    return compressedUrn;
  }

  public void setCompressedUrn(Boolean compressedUrn) {
    this.compressedUrn = compressedUrn;
  }

  public JobPayloadInput rootFilename(String rootFilename) {
    this.rootFilename = rootFilename;
    return this;
  }

   /**
   * The root filename of the compressed file. Mandatory if the `compressedUrn` is set to `true`.
   * @return rootFilename
  **/
  @ApiModelProperty(example = "null", value = "The root filename of the compressed file. Mandatory if the `compressedUrn` is set to `true`.")
  public String getRootFilename() {
    return rootFilename;
  }

  public void setRootFilename(String rootFilename) {
    this.rootFilename = rootFilename;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobPayloadInput jobPayloadInput = (JobPayloadInput) o;
    return Objects.equals(this.urn, jobPayloadInput.urn) &&
        Objects.equals(this.compressedUrn, jobPayloadInput.compressedUrn) &&
        Objects.equals(this.rootFilename, jobPayloadInput.rootFilename);
  }

  @Override
  public int hashCode() {
    return Objects.hash(urn, compressedUrn, rootFilename);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobPayloadInput {\n");
    
    sb.append("    urn: ").append(toIndentedString(urn)).append("\n");
    sb.append("    compressedUrn: ").append(toIndentedString(compressedUrn)).append("\n");
    sb.append("    rootFilename: ").append(toIndentedString(rootFilename)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

