/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;


/**
 * Advanced options for &#x60;obj&#x60; type.
 */
@ApiModel(description = "Advanced options for `obj` type.")

public class JobObjOutputPayloadAdvanced   {
  /**
   * `single` (default): creates one OBJ file for all the input files (assembly file)  `multiple`: creates a separate OBJ file for each object 
   */
  public enum ExportFileStructureEnum {
    SINGLE("single"),
    
    MULTIPLE("multiple");

    private String value;

    ExportFileStructureEnum(String value) {
      this.value = value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }
  }

  @JsonProperty("exportFileStructure")
  private ExportFileStructureEnum exportFileStructure = ExportFileStructureEnum.SINGLE;

  @JsonProperty("modelGuid")
  private String modelGuid = null;

  @JsonProperty("objectIds")
  private List<Integer> objectIds = new ArrayList<Integer>();

  public JobObjOutputPayloadAdvanced exportFileStructure(ExportFileStructureEnum exportFileStructure) {
    this.exportFileStructure = exportFileStructure;
    return this;
  }

   /**
   * `single` (default): creates one OBJ file for all the input files (assembly file)  `multiple`: creates a separate OBJ file for each object 
   * @return exportFileStructure
  **/
  @ApiModelProperty(example = "null", value = "`single` (default): creates one OBJ file for all the input files (assembly file)  `multiple`: creates a separate OBJ file for each object ")
  public ExportFileStructureEnum getExportFileStructure() {
    return exportFileStructure;
  }

  public void setExportFileStructure(ExportFileStructureEnum exportFileStructure) {
    this.exportFileStructure = exportFileStructure;
  }

  public JobObjOutputPayloadAdvanced modelGuid(String modelGuid) {
    this.modelGuid = modelGuid;
    return this;
  }

   /**
   * Required for geometry extractions. The model view ID (guid).
   * @return modelGuid
  **/
  @ApiModelProperty(example = "null", value = "Required for geometry extractions. The model view ID (guid).")
  public String getModelGuid() {
    return modelGuid;
  }

  public void setModelGuid(String modelGuid) {
    this.modelGuid = modelGuid;
  }

  public JobObjOutputPayloadAdvanced objectIds(List<Integer> objectIds) {
    this.objectIds = objectIds;
    return this;
  }

   /**
   * Required for geometry extractions. List object ids to be translated. -1 will extract the entire model. 
   * @return objectIds
  **/
  @ApiModelProperty(example = "null", value = "Required for geometry extractions. List object ids to be translated. -1 will extract the entire model. ")
  public List<Integer> getObjectIds() {
    return objectIds;
  }

  public void setObjectIds(List<Integer> objectIds) {
    this.objectIds = objectIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobObjOutputPayloadAdvanced jobObjOutputPayloadAdvanced = (JobObjOutputPayloadAdvanced) o;
    return Objects.equals(this.exportFileStructure, jobObjOutputPayloadAdvanced.exportFileStructure) &&
        Objects.equals(this.modelGuid, jobObjOutputPayloadAdvanced.modelGuid) &&
        Objects.equals(this.objectIds, jobObjOutputPayloadAdvanced.objectIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(exportFileStructure, modelGuid, objectIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobObjOutputPayloadAdvanced {\n");
    
    sb.append("    exportFileStructure: ").append(toIndentedString(exportFileStructure)).append("\n");
    sb.append("    modelGuid: ").append(toIndentedString(modelGuid)).append("\n");
    sb.append("    objectIds: ").append(toIndentedString(objectIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

