/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.autodesk.client.model.JobAcceptedJobs;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * Job
 */

public class Job   {
  @JsonProperty("result")
  private String result = null;

  @JsonProperty("urn")
  private String urn = null;

  @JsonProperty("acceptedJobs")
  private JobAcceptedJobs acceptedJobs = null;

  public Job result(String result) {
    this.result = result;
    return this;
  }

   /**
   * reporting success status
   * @return result
  **/
  @ApiModelProperty(example = "null", required = true, value = "reporting success status")
  public String getResult() {
    return result;
  }

  public void setResult(String result) {
    this.result = result;
  }

  public Job urn(String urn) {
    this.urn = urn;
    return this;
  }

   /**
   * the urn identifier of the source file
   * @return urn
  **/
  @ApiModelProperty(example = "null", required = true, value = "the urn identifier of the source file")
  public String getUrn() {
    return urn;
  }

  public void setUrn(String urn) {
    this.urn = urn;
  }

  public Job acceptedJobs(JobAcceptedJobs acceptedJobs) {
    this.acceptedJobs = acceptedJobs;
    return this;
  }

   /**
   * Get acceptedJobs
   * @return acceptedJobs
  **/
  @ApiModelProperty(example = "null", value = "")
  public JobAcceptedJobs getAcceptedJobs() {
    return acceptedJobs;
  }

  public void setAcceptedJobs(JobAcceptedJobs acceptedJobs) {
    this.acceptedJobs = acceptedJobs;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Job job = (Job) o;
    return Objects.equals(this.result, job.result) &&
        Objects.equals(this.urn, job.urn) &&
        Objects.equals(this.acceptedJobs, job.acceptedJobs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(result, urn, acceptedJobs);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Job {\n");
    
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("    urn: ").append(toIndentedString(urn)).append("\n");
    sb.append("    acceptedJobs: ").append(toIndentedString(acceptedJobs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

