/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.autodesk.client.model.BaseAttributesExtensionObject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * FolderAttributes
 */

public class FolderAttributes   {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("displayName")
  private String displayName = null;

  @JsonProperty("objectCount")
  private Integer objectCount = null;

  @JsonProperty("extension")
  private BaseAttributesExtensionObject extension = null;

  public FolderAttributes name(String name) {
    this.name = name;
    return this;
  }

   /**
   * filename used when synced to local disk
   * @return name
  **/
  @ApiModelProperty(example = "null", required = true, value = "filename used when synced to local disk")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public FolderAttributes displayName(String displayName) {
    this.displayName = displayName;
    return this;
  }

   /**
   * displayable name of the folder
   * @return displayName
  **/
  @ApiModelProperty(example = "null", required = true, value = "displayable name of the folder")
  public String getDisplayName() {
    return displayName;
  }

  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  public FolderAttributes objectCount(Integer objectCount) {
    this.objectCount = objectCount;
    return this;
  }

   /**
   * number of contained sub-folders and items
   * @return objectCount
  **/
  @ApiModelProperty(example = "null", required = true, value = "number of contained sub-folders and items")
  public Integer getObjectCount() {
    return objectCount;
  }

  public void setObjectCount(Integer objectCount) {
    this.objectCount = objectCount;
  }

  public FolderAttributes extension(BaseAttributesExtensionObject extension) {
    this.extension = extension;
    return this;
  }

   /**
   * Get extension
   * @return extension
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public BaseAttributesExtensionObject getExtension() {
    return extension;
  }

  public void setExtension(BaseAttributesExtensionObject extension) {
    this.extension = extension;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FolderAttributes folderAttributes = (FolderAttributes) o;
    return Objects.equals(this.name, folderAttributes.name) &&
        Objects.equals(this.displayName, folderAttributes.displayName) &&
        Objects.equals(this.objectCount, folderAttributes.objectCount) &&
        Objects.equals(this.extension, folderAttributes.extension);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, displayName, objectCount, extension);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FolderAttributes {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
    sb.append("    objectCount: ").append(toIndentedString(objectCount)).append("\n");
    sb.append("    extension: ").append(toIndentedString(extension)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

