/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;


/**
 * AppPackage
 */

public class AppPackage   {
  @JsonProperty("Id")
  private String id = null;

  @JsonProperty("Resource")
  private String resource = null;

  @JsonProperty("References")
  private List<String> references = new ArrayList<String>();

  @JsonProperty("RequiredEngineVersion")
  private String requiredEngineVersion = null;

  @JsonProperty("Version")
  private Integer version = null;

  @JsonProperty("Description")
  private String description = null;

  @JsonProperty("IsPublic")
  private Boolean isPublic = null;

  @JsonProperty("IsObjectEnabler")
  private Boolean isObjectEnabler = null;

  public AppPackage id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public AppPackage resource(String resource) {
    this.resource = resource;
    return this;
  }

   /**
   * Get resource
   * @return resource
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public String getResource() {
    return resource;
  }

  public void setResource(String resource) {
    this.resource = resource;
  }

  public AppPackage references(List<String> references) {
    this.references = references;
    return this;
  }

   /**
   * Get references
   * @return references
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public List<String> getReferences() {
    return references;
  }

  public void setReferences(List<String> references) {
    this.references = references;
  }

  public AppPackage requiredEngineVersion(String requiredEngineVersion) {
    this.requiredEngineVersion = requiredEngineVersion;
    return this;
  }

   /**
   * Get requiredEngineVersion
   * @return requiredEngineVersion
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public String getRequiredEngineVersion() {
    return requiredEngineVersion;
  }

  public void setRequiredEngineVersion(String requiredEngineVersion) {
    this.requiredEngineVersion = requiredEngineVersion;
  }

  public AppPackage version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(example = "null", required = true, value = "")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public AppPackage description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(example = "null", value = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AppPackage isPublic(Boolean isPublic) {
    this.isPublic = isPublic;
    return this;
  }

   /**
   * Get isPublic
   * @return isPublic
  **/
  @ApiModelProperty(example = "null", value = "")
  public Boolean getIsPublic() {
    return isPublic;
  }

  public void setIsPublic(Boolean isPublic) {
    this.isPublic = isPublic;
  }

  public AppPackage isObjectEnabler(Boolean isObjectEnabler) {
    this.isObjectEnabler = isObjectEnabler;
    return this;
  }

   /**
   * Get isObjectEnabler
   * @return isObjectEnabler
  **/
  @ApiModelProperty(example = "null", value = "")
  public Boolean getIsObjectEnabler() {
    return isObjectEnabler;
  }

  public void setIsObjectEnabler(Boolean isObjectEnabler) {
    this.isObjectEnabler = isObjectEnabler;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppPackage appPackage = (AppPackage) o;
    return Objects.equals(this.id, appPackage.id) &&
        Objects.equals(this.resource, appPackage.resource) &&
        Objects.equals(this.references, appPackage.references) &&
        Objects.equals(this.requiredEngineVersion, appPackage.requiredEngineVersion) &&
        Objects.equals(this.version, appPackage.version) &&
        Objects.equals(this.description, appPackage.description) &&
        Objects.equals(this.isPublic, appPackage.isPublic) &&
        Objects.equals(this.isObjectEnabler, appPackage.isObjectEnabler);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, resource, references, requiredEngineVersion, version, description, isPublic, isObjectEnabler);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppPackage {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
    sb.append("    references: ").append(toIndentedString(references)).append("\n");
    sb.append("    requiredEngineVersion: ").append(toIndentedString(requiredEngineVersion)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    isPublic: ").append(toIndentedString(isPublic)).append("\n");
    sb.append("    isObjectEnabler: ").append(toIndentedString(isObjectEnabler)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

