/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.autodesk.client.api;

import com.sun.jersey.api.client.GenericType;

import com.autodesk.client.ApiException;
import com.autodesk.client.ApiClient;
import com.autodesk.client.Configuration;
import com.autodesk.client.model.*;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.ApiResponse;

import java.io.File;

import com.autodesk.client.model.ObjectDetails;
import com.autodesk.client.model.PostObjectSigned;
import com.autodesk.client.model.PostBucketsSigned;
import java.io.File;
import java.util.Date;
import com.autodesk.client.model.ObjectFullDetails;
import com.autodesk.client.model.BucketObjects;
import com.autodesk.client.model.Reason;
import com.autodesk.client.model.Result;


import java.util.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class ObjectsApi {
  private ApiClient apiClient;

  public ObjectsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ObjectsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * 
   * Copies an object to another object name in the same bucket.
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @param newObjName URL-encoded Object key to use as the destination (required)
   * @return ObjectDetails
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ObjectDetails> copyTo(String bucketKey, String objectName, String newObjName,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling copyTo");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling copyTo");
    }
    
    // verify the required parameter 'newObjName' is set
    if (newObjName == null) {
      throw new ApiException(400, "Missing the required parameter 'newObjName' when calling copyTo");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/copyto/{newObjName}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()))
      .replaceAll("\\{" + "newObjName" + "\\}", apiClient.escapeString(newObjName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * This endpoint creates a signed URL that can be used to download an object within the specified expiration time. Be aware that if the object the signed URL points to is deleted or expires before the signed URL expires, then the signed URL will no longer be valid. A successful call to this endpoint requires bucket owner access.
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @param postBucketsSigned Body Structure (required)
   * @param access Access for signed resource Acceptable values: &#x60;read&#x60;, &#x60;write&#x60;, &#x60;readwrite&#x60;. Default value: &#x60;read&#x60;  (optional, default to read)
   * @return PostObjectSigned
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<PostObjectSigned> createSignedResource(String bucketKey, String objectName, PostBucketsSigned postBucketsSigned, String access,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = postBucketsSigned;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling createSignedResource");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling createSignedResource");
    }
    
    // verify the required parameter 'postBucketsSigned' is set
    if (postBucketsSigned == null) {
      throw new ApiException(400, "Missing the required parameter 'postBucketsSigned' when calling createSignedResource");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/signed".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "access", access));

    
    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<PostObjectSigned> localVarReturnType = new GenericType<PostObjectSigned>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * Deletes an object from the bucket.
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> deleteObject(String bucketKey, String objectName,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling deleteObject");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling deleteObject");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);


    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
  }
  /**
   * 
   * Delete a signed URL. A successful call to this endpoint requires bucket owner access.
   * @param id Id of signed resource (required)
   * @param region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60;  (optional, default to US)
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> deleteSignedResource(String id, String region,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling deleteSignedResource");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/signedresources/{id}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "region", region));

    
    
    final String[] localVarAccepts = {
      "text/plain"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);


    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
  }
  /**
   * 
   * Download an object.
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @param range A range of bytes to download from the specified object. (optional)
   * @param ifNoneMatch The value of this header is compared to the ETAG of the object. If they match, the body will not be included in the response. Only the object information will be included. (optional)
   * @param ifModifiedSince If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body.  (optional)
   * @param acceptEncoding When gzip is specified, a gzip compressed stream of the object’s bytes will be returned in the response. Cannot use “Accept-Encoding:gzip” with Range header containing an end byte range. End byte range will not be honored if “Accept-Encoding: gzip” header is used.  (optional)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<File> getObject(String bucketKey, String objectName, String range, String ifNoneMatch, Date ifModifiedSince, String acceptEncoding,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getObject");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling getObject");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (range != null)
      localVarHeaderParams.put("Range", apiClient.parameterToString(range));
if (ifNoneMatch != null)
      localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
if (ifModifiedSince != null)
      localVarHeaderParams.put("If-Modified-Since", apiClient.parameterToString(ifModifiedSince));
if (acceptEncoding != null)
      localVarHeaderParams.put("Accept-Encoding", apiClient.parameterToString(acceptEncoding));

    
    final String[] localVarAccepts = {
      "application/octet-stream"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<File> localVarReturnType = new GenericType<File>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * Returns object details in JSON format.
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @param ifModifiedSince If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body.  (optional)
   * @param with Extra information in details; multiple uses are supported Acceptable values: &#x60;createdDate&#x60;, &#x60;lastAccessedDate&#x60;, &#x60;lastModifiedDate&#x60;  (optional)
   * @return ObjectFullDetails
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ObjectFullDetails> getObjectDetails(String bucketKey, String objectName, Date ifModifiedSince, String with,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getObjectDetails");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling getObjectDetails");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/details".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "with", with));

    if (ifModifiedSince != null)
      localVarHeaderParams.put("If-Modified-Since", apiClient.parameterToString(ifModifiedSince));

    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<ObjectFullDetails> localVarReturnType = new GenericType<ObjectFullDetails>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * List objects in a bucket. It is only available to the bucket creator.
   * @param bucketKey URL-encoded bucket key (required)
   * @param limit Limit to the response size, Acceptable values: 1-100 Default &#x3D; 10  (optional, default to 10)
   * @param beginsWith Provides a way to filter the based on object key name (optional)
   * @param startAt Key to use as an offset to continue pagination This is typically the last bucket key found in a preceding GET buckets response  (optional)
   * @return BucketObjects
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<BucketObjects> getObjects(String bucketKey, Integer limit, String beginsWith, String startAt,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getObjects");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "beginsWith", beginsWith));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "startAt", startAt));

    
    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<BucketObjects> localVarReturnType = new GenericType<BucketObjects>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * Download an object using a signed URL.
   * @param id Id of signed resource (required)
   * @param range A range of bytes to download from the specified object. (optional)
   * @param ifNoneMatch The value of this header is compared to the ETAG of the object. If they match, the body will not be included in the response. Only the object information will be included. (optional)
   * @param ifModifiedSince If the requested object has not been modified since the time specified in this field, an entity will not be returned from the server; instead, a 304 (not modified) response will be returned without any message body.  (optional)
   * @param acceptEncoding When gzip is specified, a gzip compressed stream of the object’s bytes will be returned in the response. Cannot use “Accept-Encoding:gzip” with Range header containing an end byte range. End byte range will not be honored if “Accept-Encoding: gzip” header is used.  (optional)
   * @param region The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60;  (optional, default to US)
   * @return File
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<File> getSignedResource(String id, String range, String ifNoneMatch, Date ifModifiedSince, String acceptEncoding, String region,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getSignedResource");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/signedresources/{id}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "region", region));

    if (range != null)
      localVarHeaderParams.put("Range", apiClient.parameterToString(range));
if (ifNoneMatch != null)
      localVarHeaderParams.put("If-None-Match", apiClient.parameterToString(ifNoneMatch));
if (ifModifiedSince != null)
      localVarHeaderParams.put("If-Modified-Since", apiClient.parameterToString(ifModifiedSince));
if (acceptEncoding != null)
      localVarHeaderParams.put("Accept-Encoding", apiClient.parameterToString(acceptEncoding));

    
    final String[] localVarAccepts = {
      "application/octet-stream"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<File> localVarReturnType = new GenericType<File>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * This endpoint returns status information about a resumable upload.
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @param sessionId Unique identifier of a session of a file being uploaded (required)
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<Void> getStatusBySessionId(String bucketKey, String objectName, String sessionId,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = null;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getStatusBySessionId");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling getStatusBySessionId");
    }
    
    // verify the required parameter 'sessionId' is set
    if (sessionId == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionId' when calling getStatusBySessionId");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/status/{sessionId}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()))
      .replaceAll("\\{" + "sessionId" + "\\}", apiClient.escapeString(sessionId.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);


    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
  }
  /**
   * 
   * This endpoint allows resumable uploads for large files in chunks.
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @param contentLength Indicates the size of the request body. (required)
   * @param contentRange Byte range of a segment being uploaded (required)
   * @param sessionId Unique identifier of a session of a file being uploaded (required)
   * @param body  (required)
   * @param contentDisposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
   * @param ifMatch If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written.  (optional)
   * @return ObjectDetails
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ObjectDetails> uploadChunk(String bucketKey, String objectName, Integer contentLength, String contentRange, String sessionId, File body, String contentDisposition, String ifMatch,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = body;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling uploadChunk");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling uploadChunk");
    }
    
    // verify the required parameter 'contentLength' is set
    if (contentLength == null) {
      throw new ApiException(400, "Missing the required parameter 'contentLength' when calling uploadChunk");
    }
    
    // verify the required parameter 'contentRange' is set
    if (contentRange == null) {
      throw new ApiException(400, "Missing the required parameter 'contentRange' when calling uploadChunk");
    }
    
    // verify the required parameter 'sessionId' is set
    if (sessionId == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadChunk");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling uploadChunk");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/resumable".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (contentLength != null)
      localVarHeaderParams.put("Content-Length", apiClient.parameterToString(contentLength));
if (contentRange != null)
      localVarHeaderParams.put("Content-Range", apiClient.parameterToString(contentRange));
if (contentDisposition != null)
      localVarHeaderParams.put("Content-Disposition", apiClient.parameterToString(contentDisposition));
if (ifMatch != null)
      localVarHeaderParams.put("If-Match", apiClient.parameterToString(ifMatch));
if (sessionId != null)
      localVarHeaderParams.put("Session-Id", apiClient.parameterToString(sessionId));

    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/octet-stream"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * Upload an object. If the specified object name already exists in the bucket, the uploaded content will overwrite the existing content for the bucket name/object name combination. 
   * @param bucketKey URL-encoded bucket key (required)
   * @param objectName URL-encoded object name (required)
   * @param contentLength Indicates the size of the request body. (required)
   * @param body  (required)
   * @param contentDisposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
   * @param ifMatch If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written.  (optional)
   * @return ObjectDetails
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ObjectDetails> uploadObject(String bucketKey, String objectName, Integer contentLength, File body, String contentDisposition, String ifMatch,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = body;
    
    // verify the required parameter 'bucketKey' is set
    if (bucketKey == null) {
      throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling uploadObject");
    }
    
    // verify the required parameter 'objectName' is set
    if (objectName == null) {
      throw new ApiException(400, "Missing the required parameter 'objectName' when calling uploadObject");
    }
    
    // verify the required parameter 'contentLength' is set
    if (contentLength == null) {
      throw new ApiException(400, "Missing the required parameter 'contentLength' when calling uploadObject");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling uploadObject");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "bucketKey" + "\\}", apiClient.escapeString(bucketKey.toString()))
      .replaceAll("\\{" + "objectName" + "\\}", apiClient.escapeString(objectName.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (contentLength != null)
      localVarHeaderParams.put("Content-Length", apiClient.parameterToString(contentLength));
if (contentDisposition != null)
      localVarHeaderParams.put("Content-Disposition", apiClient.parameterToString(contentDisposition));
if (ifMatch != null)
      localVarHeaderParams.put("If-Match", apiClient.parameterToString(ifMatch));

    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/octet-stream"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * Overwrite a existing object using a signed URL.  Conditions to call this operation:  Object is available Expiration period is valid Signed URL should be created with &#x60;write&#x60; or &#x60;readwrite&#x60; 
   * @param id Id of signed resource (required)
   * @param contentLength Indicates the size of the request body. (required)
   * @param body  (required)
   * @param contentDisposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
   * @param xAdsRegion The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60;  (optional, default to US)
   * @param ifMatch If-Match header containing a SHA-1 hash of the bytes in the request body can be sent by the calling service or client application with the request. If present, OSS will use the value of If-Match header to verify that a SHA-1 calculated for the uploaded bytes server side matches what was sent in the header. If not, the request is failed with a status 412 Precondition Failed and the data is not written.  (optional)
   * @return ObjectDetails
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ObjectDetails> uploadSignedResource(String id, Integer contentLength, File body, String contentDisposition, String xAdsRegion, String ifMatch,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = body;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling uploadSignedResource");
    }
    
    // verify the required parameter 'contentLength' is set
    if (contentLength == null) {
      throw new ApiException(400, "Missing the required parameter 'contentLength' when calling uploadSignedResource");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling uploadSignedResource");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/signedresources/{id}".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (contentLength != null)
      localVarHeaderParams.put("Content-Length", apiClient.parameterToString(contentLength));
if (contentDisposition != null)
      localVarHeaderParams.put("Content-Disposition", apiClient.parameterToString(contentDisposition));
if (xAdsRegion != null)
      localVarHeaderParams.put("x-ads-region", apiClient.parameterToString(xAdsRegion));
if (ifMatch != null)
      localVarHeaderParams.put("If-Match", apiClient.parameterToString(ifMatch));

    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/octet-stream"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
  /**
   * 
   * Resumable upload for signed URLs.
   * @param id Id of signed resource (required)
   * @param contentRange Byte range of a segment being uploaded (required)
   * @param sessionId Unique identifier of a session of a file being uploaded (required)
   * @param body  (required)
   * @param contentDisposition The suggested default filename when downloading this object to a file after it has been uploaded. (optional)
   * @param xAdsRegion The region where the bucket resides Acceptable values: &#x60;US&#x60;, &#x60;EMEA&#x60; Default is &#x60;US&#x60;  (optional, default to US)
   * @return ObjectDetails
   * @throws ApiException if fails to make API call
   */
  public ApiResponse<ObjectDetails> uploadSignedResourcesChunk(String id, String contentRange, String sessionId, File body, String contentDisposition, String xAdsRegion,  Authentication oauth2, Credentials credentials) throws ApiException, Exception {

    Object localVarPostBody = body;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling uploadSignedResourcesChunk");
    }
    
    // verify the required parameter 'contentRange' is set
    if (contentRange == null) {
      throw new ApiException(400, "Missing the required parameter 'contentRange' when calling uploadSignedResourcesChunk");
    }
    
    // verify the required parameter 'sessionId' is set
    if (sessionId == null) {
      throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadSignedResourcesChunk");
    }
    
    // verify the required parameter 'body' is set
    if (body == null) {
      throw new ApiException(400, "Missing the required parameter 'body' when calling uploadSignedResourcesChunk");
    }
    
    // create path and map variables
    String localVarPath = "/oss/v2/signedresources/{id}/resumable".replaceAll("\\{format\\}","json")
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(id.toString()));

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (contentRange != null)
      localVarHeaderParams.put("Content-Range", apiClient.parameterToString(contentRange));
if (contentDisposition != null)
      localVarHeaderParams.put("Content-Disposition", apiClient.parameterToString(contentDisposition));
if (xAdsRegion != null)
      localVarHeaderParams.put("x-ads-region", apiClient.parameterToString(xAdsRegion));
if (sessionId != null)
      localVarHeaderParams.put("Session-Id", apiClient.parameterToString(sessionId));

    
    final String[] localVarAccepts = {
      "application/vnd.api+json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/octet-stream"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>() {};
    return apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
      }
}
