/*
 * Forge SDK
 * The Forge Platform contains an expanding collection of web service components that can be used with Autodesk cloud-based products or your own technologies. Take advantage of Autodesk’s expertise in design and engineering.
 *
 * OpenAPI spec version: 0.1.0
 * Contact: forge.help@autodesk.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package com.autodesk.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;



public class StringUtil {
  /**
   * Check if the given array contains the given value (with case-insensitive comparison).
   *
   * @param array The array
   * @param value The value to search
   * @return true if the array contains the value
   */
  public static boolean containsIgnoreCase(String[] array, String value) {
    for (String str : array) {
      if (value == null && str == null) return true;
      if (value != null && value.equalsIgnoreCase(str)) return true;
    }
    return false;
  }

  /**
   * Join an array of strings with the given separator.
   * <p>
   * Note: This might be replaced by utility method from commons-lang or guava someday
   * if one of those libraries is added as dependency.
   * </p>
   *
   * @param array     The array of strings
   * @param separator The separator
   * @return the resulting string
   */
  public static String join(String[] array, String separator) {
    int len = array.length;
    if (len == 0) return "";

    StringBuilder out = new StringBuilder();
    out.append(array[0]);
    for (int i = 1; i < len; i++) {
      out.append(separator).append(array[i]);
    }
    return out.toString();
  }

	public static class JacksonMapper {

		private static final ObjectMapper mapper = new ObjectMapper();

		private static final JacksonMapper INSTANCE;

		static {
			INSTANCE = new JacksonMapper();
		}

		private JacksonMapper() {
			// not called
		}

		public static JacksonMapper getInstance() {

			return INSTANCE;
		}

		public Map<String, String> toMap(String jsonString) throws Exception {

			return mapper.readValue(jsonString, new TypeReference<HashMap<String, String>>() {
			});

		}
		/**
		 * Convert JSON to {@link List} {@link Pair}
		 * @param jsonString
		 * @return
		 * @throws Exception
		 */
		public List<Pair> toListPair(String jsonString) throws Exception {
			List<Pair> list = new ArrayList<>();
			Map<String, String> map = toMap(jsonString);
			for (Map.Entry<String, String> entry : map.entrySet())
			{
				list.add(new Pair(entry.getKey(), entry.getValue()));
			}
			return list;
		}
		
	}
}

