/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class UploadFile {
    @JsonProperty(value="bucketKey")
    private String bucketKey = null;
    @JsonProperty(value="objectId")
    private String objectId = null;
    @JsonProperty(value="objectKey")
    private String objectKey = null;
    @JsonProperty(value="sha1")
    private String sha1 = null;
    @JsonProperty(value="size")
    private Integer size = null;
    @JsonProperty(value="contentType")
    private String contentType = null;
    @JsonProperty(value="location")
    private String location = null;

    public UploadFile bucketKey(String bucketKey) {
        this.bucketKey = bucketKey;
        return this;
    }

    @ApiModelProperty(example="null", value="The key of the Bucket")
    public String getBucketKey() {
        return this.bucketKey;
    }

    public void setBucketKey(String bucketKey) {
        this.bucketKey = bucketKey;
    }

    public UploadFile objectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    @ApiModelProperty(example="null", value="The object id")
    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public UploadFile objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @ApiModelProperty(example="null", value="The key for uploaded object")
    public String getObjectKey() {
        return this.objectKey;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public UploadFile sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    @ApiModelProperty(example="null", value="The hash value for uploaded object (fingerprint)")
    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public UploadFile size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(example="null", value="The size (bytes) of the uploaded object")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public UploadFile contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", value="The content-type of uploaded object")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public UploadFile location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="The location from which you can download the object (download URL)")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadFile uploadFile = (UploadFile)o;
        return Objects.equals(this.bucketKey, uploadFile.bucketKey) && Objects.equals(this.objectId, uploadFile.objectId) && Objects.equals(this.objectKey, uploadFile.objectKey) && Objects.equals(this.sha1, uploadFile.sha1) && Objects.equals(this.size, uploadFile.size) && Objects.equals(this.contentType, uploadFile.contentType) && Objects.equals(this.location, uploadFile.location);
    }

    public int hashCode() {
        return Objects.hash(this.bucketKey, this.objectId, this.objectKey, this.sha1, this.size, this.contentType, this.location);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadFile {\n");
        sb.append("    bucketKey: ").append(this.toIndentedString(this.bucketKey)).append("\n");
        sb.append("    objectId: ").append(this.toIndentedString(this.objectId)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    sha1: ").append(this.toIndentedString(this.sha1)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

