/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.autodesk.client.model.ManifestChildren;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Requested output files for the source file URN")
public class ManifestDerivative {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="hasThumbnail")
    private Boolean hasThumbnail = null;
    @JsonProperty(value="outputType")
    private OutputTypeEnum outputType = null;
    @JsonProperty(value="progress")
    private String progress = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="children")
    private List<ManifestChildren> children = new ArrayList<ManifestChildren>();

    public ManifestDerivative name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Output file type")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ManifestDerivative hasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates if a thumbnail has been generated")
    public Boolean getHasThumbnail() {
        return this.hasThumbnail;
    }

    public void setHasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
    }

    public ManifestDerivative outputType(OutputTypeEnum outputType) {
        this.outputType = outputType;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public OutputTypeEnum getOutputType() {
        return this.outputType;
    }

    public void setOutputType(OutputTypeEnum outputType) {
        this.outputType = outputType;
    }

    public ManifestDerivative progress(String progress) {
        this.progress = progress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Translation progress for requested entity")
    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public ManifestDerivative status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Status of the requested entity; possible values are: `pending`, `success`, `inprogress`, `failed`, `timeout` and `partialsuccess` ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ManifestDerivative children(List<ManifestChildren> children) {
        this.children = children;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="")
    public List<ManifestChildren> getChildren() {
        return this.children;
    }

    public void setChildren(List<ManifestChildren> children) {
        this.children = children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestDerivative manifestDerivative = (ManifestDerivative)o;
        return Objects.equals(this.name, manifestDerivative.name) && Objects.equals(this.hasThumbnail, manifestDerivative.hasThumbnail) && Objects.equals((Object)this.outputType, (Object)manifestDerivative.outputType) && Objects.equals(this.progress, manifestDerivative.progress) && Objects.equals((Object)this.status, (Object)manifestDerivative.status) && Objects.equals(this.children, manifestDerivative.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hasThumbnail, this.outputType, this.progress, this.status, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManifestDerivative {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hasThumbnail: ").append(this.toIndentedString(this.hasThumbnail)).append("\n");
        sb.append("    outputType: ").append(this.toIndentedString((Object)this.outputType)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        INPROGRESS("inprogress"),
        SUCCESS("success"),
        FAILED("failed"),
        TIMEOUT("timeout"),
        PARTIALSUCCESS("partialsuccess");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum OutputTypeEnum {
        STL("stl"),
        STEP("step"),
        IGES("iges"),
        OBJ("obj"),
        SVF("svf"),
        THUMBNAIL("thumbnail");

        private String value;

        private OutputTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

