/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.autodesk.client.model.Messages;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Children Manifest")
public class ManifestChildren {
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="role")
    private RoleEnum role = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="hasThumbnail")
    private Boolean hasThumbnail = null;
    @JsonProperty(value="mime")
    private String mime = null;
    @JsonProperty(value="urn")
    private String urn = null;
    @JsonProperty(value="progress")
    private String progress = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="resolution")
    private List<String> resolution = new ArrayList<String>();
    @JsonProperty(value="modelGUID")
    private String modelGUID = null;
    @JsonProperty(value="objectIds")
    private List<Integer> objectIds = new ArrayList<Integer>();
    @JsonProperty(value="messages")
    private Messages messages = null;

    public ManifestChildren type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this JSON object")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ManifestChildren role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Output file type")
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public ManifestChildren name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Output file type")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ManifestChildren hasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if a thumbnail has been generated ")
    public Boolean getHasThumbnail() {
        return this.hasThumbnail;
    }

    public void setHasThumbnail(Boolean hasThumbnail) {
        this.hasThumbnail = hasThumbnail;
    }

    public ManifestChildren mime(String mime) {
        this.mime = mime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="MIME type of the generated file")
    public String getMime() {
        return this.mime;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public ManifestChildren urn(String urn) {
        this.urn = urn;
        return this;
    }

    @ApiModelProperty(example="null", value="Output file URN; used as a file identifier")
    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public ManifestChildren progress(String progress) {
        this.progress = progress;
        return this;
    }

    @ApiModelProperty(example="null", value="Translation progress for requested entity")
    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public ManifestChildren status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the requested entity; possible values are: `pending`, `success`, `inprogress`, `failed`, `timeout` and `partialsuccess` ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ManifestChildren resolution(List<String> resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(example="null", value="Available thumbnail resolution")
    public List<String> getResolution() {
        return this.resolution;
    }

    public void setResolution(List<String> resolution) {
        this.resolution = resolution;
    }

    public ManifestChildren modelGUID(String modelGUID) {
        this.modelGUID = modelGUID;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getModelGUID() {
        return this.modelGUID;
    }

    public void setModelGUID(String modelGUID) {
        this.modelGUID = modelGUID;
    }

    public ManifestChildren objectIds(List<Integer> objectIds) {
        this.objectIds = objectIds;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<Integer> getObjectIds() {
        return this.objectIds;
    }

    public void setObjectIds(List<Integer> objectIds) {
        this.objectIds = objectIds;
    }

    public ManifestChildren messages(Messages messages) {
        this.messages = messages;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Messages getMessages() {
        return this.messages;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestChildren manifestChildren = (ManifestChildren)o;
        return Objects.equals((Object)this.type, (Object)manifestChildren.type) && Objects.equals((Object)this.role, (Object)manifestChildren.role) && Objects.equals(this.name, manifestChildren.name) && Objects.equals(this.hasThumbnail, manifestChildren.hasThumbnail) && Objects.equals(this.mime, manifestChildren.mime) && Objects.equals(this.urn, manifestChildren.urn) && Objects.equals(this.progress, manifestChildren.progress) && Objects.equals((Object)this.status, (Object)manifestChildren.status) && Objects.equals(this.resolution, manifestChildren.resolution) && Objects.equals(this.modelGUID, manifestChildren.modelGUID) && Objects.equals(this.objectIds, manifestChildren.objectIds) && Objects.equals(this.messages, manifestChildren.messages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.role, this.name, this.hasThumbnail, this.mime, this.urn, this.progress, this.status, this.resolution, this.modelGUID, this.objectIds, this.messages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ManifestChildren {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hasThumbnail: ").append(this.toIndentedString(this.hasThumbnail)).append("\n");
        sb.append("    mime: ").append(this.toIndentedString(this.mime)).append("\n");
        sb.append("    urn: ").append(this.toIndentedString(this.urn)).append("\n");
        sb.append("    progress: ").append(this.toIndentedString(this.progress)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("    modelGUID: ").append(this.toIndentedString(this.modelGUID)).append("\n");
        sb.append("    objectIds: ").append(this.toIndentedString(this.objectIds)).append("\n");
        sb.append("    messages: ").append(this.toIndentedString(this.messages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        INPROGRESS("inprogress"),
        SUCCESS("success"),
        FAILED("failed"),
        TIMEOUT("timeout"),
        PARTIALSUCCESS("partialsuccess");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum RoleEnum {
        _2D("2d"),
        _3D("3d"),
        GRAPHICS("graphics"),
        MANIFEST("manifest"),
        THUMBNAIL("thumbnail"),
        PROPERTYDB("Autodesk.CloudPlatform.PropertyDatabase");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TypeEnum {
        RESOURCE("resource"),
        MANIFEST("manifest"),
        GEOMETRY("geometry"),
        VIEW("view");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

