/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Advanced options for `stl` type.")
public class JobStlOutputPayloadAdvanced {
    @JsonProperty(value="format")
    private FormatEnum format = FormatEnum.BINARY;
    @JsonProperty(value="exportColor")
    private Boolean exportColor = true;
    @JsonProperty(value="exportFileStructure")
    private ExportFileStructureEnum exportFileStructure = ExportFileStructureEnum.SINGLE;

    public JobStlOutputPayloadAdvanced format(FormatEnum format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(example="null", value="Default format is `binary`. Possible values are `binary` or `ascii`.")
    public FormatEnum getFormat() {
        return this.format;
    }

    public void setFormat(FormatEnum format) {
        this.format = format;
    }

    public JobStlOutputPayloadAdvanced exportColor(Boolean exportColor) {
        this.exportColor = exportColor;
        return this;
    }

    @ApiModelProperty(example="null", value="Color is exported by default. If set to `true`, color is exported. If set to `false`, color is not exported.")
    public Boolean getExportColor() {
        return this.exportColor;
    }

    public void setExportColor(Boolean exportColor) {
        this.exportColor = exportColor;
    }

    public JobStlOutputPayloadAdvanced exportFileStructure(ExportFileStructureEnum exportFileStructure) {
        this.exportFileStructure = exportFileStructure;
        return this;
    }

    @ApiModelProperty(example="null", value="`single` (default): creates one STL file for all the input files (assembly file)  `multiple`: creates a separate STL file for each object ")
    public ExportFileStructureEnum getExportFileStructure() {
        return this.exportFileStructure;
    }

    public void setExportFileStructure(ExportFileStructureEnum exportFileStructure) {
        this.exportFileStructure = exportFileStructure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobStlOutputPayloadAdvanced jobStlOutputPayloadAdvanced = (JobStlOutputPayloadAdvanced)o;
        return Objects.equals((Object)this.format, (Object)jobStlOutputPayloadAdvanced.format) && Objects.equals(this.exportColor, jobStlOutputPayloadAdvanced.exportColor) && Objects.equals((Object)this.exportFileStructure, (Object)jobStlOutputPayloadAdvanced.exportFileStructure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.exportColor, this.exportFileStructure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobStlOutputPayloadAdvanced {\n");
        sb.append("    format: ").append(this.toIndentedString((Object)this.format)).append("\n");
        sb.append("    exportColor: ").append(this.toIndentedString(this.exportColor)).append("\n");
        sb.append("    exportFileStructure: ").append(this.toIndentedString((Object)this.exportFileStructure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExportFileStructureEnum {
        SINGLE("single"),
        MULTIPLE("multiple");

        private String value;

        private ExportFileStructureEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FormatEnum {
        BINARY("binary"),
        ASCII("ascii");

        private String value;

        private FormatEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

