/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Advanced options for `iges` type.")
public class JobIgesOutputPayloadAdvanced {
    @JsonProperty(value="tolerance")
    private Float tolerance = Float.valueOf(0.001f);
    @JsonProperty(value="surfaceType")
    private SurfaceTypeEnum surfaceType = SurfaceTypeEnum.BOUNDED;
    @JsonProperty(value="sheetType")
    private SheetTypeEnum sheetType = SheetTypeEnum.SURFACE;
    @JsonProperty(value="solidType")
    private SolidTypeEnum solidType = SolidTypeEnum.SOLID;

    public JobIgesOutputPayloadAdvanced tolerance(Float tolerance) {
        this.tolerance = tolerance;
        return this;
    }

    @ApiModelProperty(example="null", value="Possible values are between `0` and `1`. By default it is set at 0.001.")
    public Float getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(Float tolerance) {
        this.tolerance = tolerance;
    }

    public JobIgesOutputPayloadAdvanced surfaceType(SurfaceTypeEnum surfaceType) {
        this.surfaceType = surfaceType;
        return this;
    }

    @ApiModelProperty(example="null", value="Possible values are `bounded`, `trimmed` and `wireframe`. By default it is set to bounded surface.")
    public SurfaceTypeEnum getSurfaceType() {
        return this.surfaceType;
    }

    public void setSurfaceType(SurfaceTypeEnum surfaceType) {
        this.surfaceType = surfaceType;
    }

    public JobIgesOutputPayloadAdvanced sheetType(SheetTypeEnum sheetType) {
        this.sheetType = sheetType;
        return this;
    }

    @ApiModelProperty(example="null", value="Export the sheet body to IGES. `open`, `shell`, `surface` or `wireframe`. By default, it is set to `surface`.")
    public SheetTypeEnum getSheetType() {
        return this.sheetType;
    }

    public void setSheetType(SheetTypeEnum sheetType) {
        this.sheetType = sheetType;
    }

    public JobIgesOutputPayloadAdvanced solidType(SolidTypeEnum solidType) {
        this.solidType = solidType;
        return this;
    }

    @ApiModelProperty(example="null", value="Export the solid body to IGES `solid`, `surface` or `wireframe`. By default, it is set to `solid`.")
    public SolidTypeEnum getSolidType() {
        return this.solidType;
    }

    public void setSolidType(SolidTypeEnum solidType) {
        this.solidType = solidType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobIgesOutputPayloadAdvanced jobIgesOutputPayloadAdvanced = (JobIgesOutputPayloadAdvanced)o;
        return Objects.equals(this.tolerance, jobIgesOutputPayloadAdvanced.tolerance) && Objects.equals((Object)this.surfaceType, (Object)jobIgesOutputPayloadAdvanced.surfaceType) && Objects.equals((Object)this.sheetType, (Object)jobIgesOutputPayloadAdvanced.sheetType) && Objects.equals((Object)this.solidType, (Object)jobIgesOutputPayloadAdvanced.solidType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tolerance, this.surfaceType, this.sheetType, this.solidType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobIgesOutputPayloadAdvanced {\n");
        sb.append("    tolerance: ").append(this.toIndentedString(this.tolerance)).append("\n");
        sb.append("    surfaceType: ").append(this.toIndentedString((Object)this.surfaceType)).append("\n");
        sb.append("    sheetType: ").append(this.toIndentedString((Object)this.sheetType)).append("\n");
        sb.append("    solidType: ").append(this.toIndentedString((Object)this.solidType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SolidTypeEnum {
        SOLID("solid"),
        SURFACE("surface"),
        WIREFRAME("wireframe");

        private String value;

        private SolidTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum SheetTypeEnum {
        OPEN("open"),
        SURFACE("surface"),
        SHELL("shell"),
        WIREFRAME("wireframe");

        private String value;

        private SheetTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum SurfaceTypeEnum {
        BOUNDED("bounded"),
        TRIMMED("trimmed"),
        WIREFRAME("wireframe");

        private String value;

        private SurfaceTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

