/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.auth;

import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.auth.OAuthFlow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OAuth2TwoLegged
implements Authentication {
    private Credentials credentials;
    private String name;
    private String type;
    private OAuthFlow flow = OAuthFlow.application;
    private String tokenUrl;
    private List<String> scopes = new ArrayList<String>();
    private List<String> selectedScopes;
    private String clientId;
    private String clientSecret;
    private Boolean autoRefresh;

    private String post(String url, Map<String, String> formParameters, Map<String, String> headers) throws ClientProtocolException, IOException {
        HttpPost request = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (String key : headers.keySet()) {
            request.setHeader(key, headers.get(key));
        }
        for (String key : formParameters.keySet()) {
            nvps.add(new BasicNameValuePair(key, formParameters.get(key)));
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        return this.execute((HttpRequestBase)request);
    }

    private String execute(HttpRequestBase request) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        String body = EntityUtils.toString((HttpEntity)entity);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException("Expected 200 but got " + response.getStatusLine().getStatusCode() + ", with body " + body);
        }
        return body;
    }

    private String getScopes() {
        String scopeStr = "";
        if (!this.selectedScopes.isEmpty()) {
            int index = 0;
            for (String key : this.selectedScopes) {
                ++index;
                if (!this.scopes.contains(key)) continue;
                scopeStr = scopeStr + key;
                if (index >= this.selectedScopes.size()) continue;
                scopeStr = scopeStr + " ";
            }
        }
        return scopeStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean validateScopes(List<String> selectedScopes) throws Exception {
        if (this.scopes.size() <= 0) throw new Exception("Authentication does not allow any scopes");
        if (selectedScopes == null || selectedScopes.size() <= 0) throw new Exception("Scope is missing or empty, you must provide a valid scope");
        for (String key : selectedScopes) {
            if (this.scopes.contains(key)) continue;
            throw new Exception(key + " scope is not allowed");
        }
        return true;
    }

    public OAuth2TwoLegged(String clientId, String clientSecret, List<String> selectedScopes, Boolean autoRefresh) throws Exception {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.selectedScopes = selectedScopes;
        this.autoRefresh = autoRefresh;
        this.name = "oauth2_application";
        this.type = "oauth2";
        this.tokenUrl = Configuration.getDefaultApiClient().getBasePath() + "/authentication/v1/authenticate";
        this.scopes.add("data:read");
        this.scopes.add("data:write");
        this.scopes.add("data:create");
        this.scopes.add("data:search");
        this.scopes.add("bucket:create");
        this.scopes.add("bucket:read");
        this.scopes.add("bucket:update");
        this.scopes.add("bucket:delete");
        this.scopes.add("code:all");
        this.scopes.add("account:read");
        this.scopes.add("account:write");
        this.scopes.add("user-profile:read");
        this.scopes.add("viewables:read");
        this.validateScopes(selectedScopes);
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) {
        if (this.credentials != null && this.credentials.getAccessToken() != null) {
            headerParams.put("Authorization", "Bearer " + this.credentials.getAccessToken());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setSelectedScopes(List<String> selectedScopes) throws Exception {
        if (this.validateScopes(selectedScopes).booleanValue()) {
            this.selectedScopes = selectedScopes;
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public Credentials authenticate() throws Exception {
        if (this.flow == OAuthFlow.application) {
            String url = this.tokenUrl;
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("grant_type", "client_credentials");
            body.put("client_id", this.clientId);
            body.put("client_secret", this.clientSecret);
            String scopeStr = this.getScopes();
            if (!scopeStr.isEmpty()) {
                body.put("scope", scopeStr);
            }
            Credentials response = null;
            try {
                String bodyResponse = this.post(url, body, new HashMap<String, String>());
                JSONObject jsonObject = null;
                try {
                    jsonObject = (JSONObject)new JSONParser().parse(bodyResponse);
                    String access_token = (String)jsonObject.get((Object)"access_token");
                    long expires_in = (Long)jsonObject.get((Object)"expires_in");
                    DateTime later = DateTime.now().plusSeconds((int)expires_in);
                    Long expiresAt = later.toDate().getTime();
                    this.credentials = new Credentials(access_token, expiresAt);
                    response = new Credentials(access_token, expiresAt);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to parse json " + body);
                }
            }
            catch (IOException e) {
                System.err.println("Exception when trying to get access token");
                e.printStackTrace();
            }
            return response;
        }
        throw new Exception("getAccessToken requires application flow type");
    }

    public Boolean isAccessTokenExpired() {
        return this.credentials != null && this.credentials.getExpiresAt() <= new Date().getTime();
    }
}

