/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.auth;

import com.autodesk.client.ApiException;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.OAuthFlow;
import com.autodesk.client.auth.ThreeLeggedCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class OAuth2ThreeLegged
implements Authentication {
    private String name;
    private String type;
    private OAuthFlow flow = OAuthFlow.accessCode;
    private String tokenUrl;
    private String authorizationUrl;
    private String refreshTokenUrl;
    private List<String> scopes = new ArrayList<String>();
    private List<String> selectedScopes;
    private String clientId;
    private String clientSecret;
    private String redirectUri;
    private Boolean autoRefresh;

    private String post(String url, Map<String, String> formParameters, Map<String, String> headers) throws ClientProtocolException, IOException, ApiException {
        HttpPost request = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (String key : headers.keySet()) {
            request.setHeader(key, headers.get(key));
        }
        for (String key : formParameters.keySet()) {
            nvps.add(new BasicNameValuePair(key, formParameters.get(key)));
        }
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
        return this.execute((HttpRequestBase)request);
    }

    private String execute(HttpRequestBase request) throws ClientProtocolException, IOException, ApiException {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        String body = EntityUtils.toString((HttpEntity)entity);
        int status = response.getStatusLine().getStatusCode();
        if (status != 200) {
            throw new ApiException(status, body);
        }
        return body;
    }

    private String getScopes() {
        String scopeStr = "";
        if (!this.selectedScopes.isEmpty()) {
            int index = 0;
            for (String key : this.selectedScopes) {
                ++index;
                if (!this.scopes.contains(key)) continue;
                scopeStr = scopeStr + key;
                if (index >= this.selectedScopes.size()) continue;
                scopeStr = scopeStr + "%20";
            }
        }
        return scopeStr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean validateScopes(List<String> selectedScopes) throws Exception {
        if (this.scopes.size() <= 0) throw new Exception("Authentication does not allow any scopes");
        if (selectedScopes == null || selectedScopes.size() <= 0) throw new Exception("Scope is missing or empty, you must provide a valid scope");
        for (String key : selectedScopes) {
            if (this.scopes.contains(key)) continue;
            throw new Exception(key + " scope is not allowed");
        }
        return true;
    }

    public OAuth2ThreeLegged(String clientId, String clientSecret, String redirectUri, List<String> selectedScopes, Boolean autoRefresh) throws Exception {
        this.redirectUri = redirectUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.selectedScopes = selectedScopes;
        this.autoRefresh = autoRefresh;
        this.name = "oauth2_access_code";
        this.type = "oauth2";
        this.tokenUrl = Configuration.getDefaultApiClient().getBasePath() + "/authentication/v1/gettoken";
        this.authorizationUrl = Configuration.getDefaultApiClient().getBasePath() + "/authentication/v1/authorize";
        this.refreshTokenUrl = Configuration.getDefaultApiClient().getBasePath() + "/authentication/v1/refreshtoken";
        this.scopes.add("data:read");
        this.scopes.add("data:write");
        this.scopes.add("data:create");
        this.scopes.add("data:search");
        this.scopes.add("bucket:create");
        this.scopes.add("bucket:read");
        this.scopes.add("bucket:update");
        this.scopes.add("bucket:delete");
        this.scopes.add("code:all");
        this.scopes.add("account:read");
        this.scopes.add("account:write");
        this.scopes.add("user-profile:read");
        this.scopes.add("viewables:read");
        this.validateScopes(selectedScopes);
    }

    @Override
    @Deprecated
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) {
    }

    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams, ThreeLeggedCredentials credentials) {
        if (credentials != null && credentials.getAccessToken() != null) {
            headerParams.put("Authorization", "Bearer " + credentials.getAccessToken());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setSelectedScopes(List<String> selectedScopes) throws Exception {
        if (this.validateScopes(selectedScopes).booleanValue()) {
            this.selectedScopes = selectedScopes;
        }
    }

    public Boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public String getAuthenticationUrl() throws Exception {
        if (this.flow == OAuthFlow.accessCode) {
            StringBuilder oauthUrl = new StringBuilder().append(this.authorizationUrl).append("?client_id=").append(this.clientId).append("&response_type=code").append("&redirect_uri=").append(this.redirectUri);
            String scopeStr = this.getScopes();
            if (!scopeStr.isEmpty()) {
                oauthUrl.append("&scope=").append(scopeStr);
            }
            return oauthUrl.toString();
        }
        throw new Exception("getAuthToken requires accessCode flow type");
    }

    public ThreeLeggedCredentials getAccessToken(String code) throws Exception {
        if (this.flow == OAuthFlow.accessCode) {
            HashMap<String, String> formParams = new HashMap<String, String>();
            formParams.put("client_id", this.clientId);
            formParams.put("client_secret", this.clientSecret);
            formParams.put("code", code);
            formParams.put("grant_type", "authorization_code");
            formParams.put("redirect_uri", this.redirectUri);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/x-www-form-urlencoded");
            ThreeLeggedCredentials response = null;
            try {
                String responseBody = this.post(this.tokenUrl, formParams, headers);
                JSONObject jsonObject = null;
                try {
                    jsonObject = (JSONObject)new JSONParser().parse(responseBody);
                    String access_token = (String)jsonObject.get((Object)"access_token");
                    String refresh_token = (String)jsonObject.get((Object)"refresh_token");
                    long expires_in = (Long)jsonObject.get((Object)"expires_in");
                    DateTime later = DateTime.now().plusSeconds((int)expires_in);
                    Long expiresAt = later.toDate().getTime();
                    response = new ThreeLeggedCredentials(access_token, expiresAt, refresh_token);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Unable to parse json " + responseBody);
                }
            }
            catch (IOException e) {
                System.err.println("Exception when trying to get access token");
                e.printStackTrace();
            }
            return response;
        }
        throw new Exception("getAuthToken requires accessCode flow type");
    }

    public ThreeLeggedCredentials refreshAccessToken(String refreshToken) {
        HashMap<String, String> formParams = new HashMap<String, String>();
        formParams.put("client_id", this.clientId);
        formParams.put("client_secret", this.clientSecret);
        formParams.put("grant_type", "refresh_token");
        formParams.put("refresh_token", refreshToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        ThreeLeggedCredentials response = null;
        try {
            String responseBody = this.post(this.refreshTokenUrl, formParams, headers);
            JSONObject jsonObject = null;
            try {
                jsonObject = (JSONObject)new JSONParser().parse(responseBody);
                String access_token = (String)jsonObject.get((Object)"access_token");
                String refresh_token = (String)jsonObject.get((Object)"refresh_token");
                long expires_in = (Long)jsonObject.get((Object)"expires_in");
                DateTime later = DateTime.now().plusSeconds((int)expires_in);
                Long expiresAt = later.toDate().getTime();
                response = new ThreeLeggedCredentials(access_token, expiresAt, refresh_token);
            }
            catch (ParseException e) {
                throw new RuntimeException("Unable to parse json " + responseBody);
            }
        }
        catch (IOException e) {
            System.err.println("Exception when trying to refresh token");
            e.printStackTrace();
        }
        catch (ApiException e) {
            System.err.println("Exception when trying to refresh token");
            e.printStackTrace();
        }
        return response;
    }

    public Boolean isAuthorized(ThreeLeggedCredentials credentials) {
        return credentials != null && credentials.getExpiresAt() != null && credentials.getExpiresAt() > new Date().getTime();
    }
}

