/*
 * Decompiled with CFR 0.152.
 */
package com.autodesk.client.api;

import com.autodesk.client.ApiClient;
import com.autodesk.client.ApiException;
import com.autodesk.client.ApiResponse;
import com.autodesk.client.Configuration;
import com.autodesk.client.Pair;
import com.autodesk.client.auth.Authentication;
import com.autodesk.client.auth.Credentials;
import com.autodesk.client.model.BucketObjects;
import com.autodesk.client.model.ObjectDetails;
import com.autodesk.client.model.ObjectFullDetails;
import com.autodesk.client.model.PostBucketsSigned;
import com.autodesk.client.model.PostObjectSigned;
import com.sun.jersey.api.client.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class ObjectsApi {
    private ApiClient apiClient;

    public ObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ObjectsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiResponse<ObjectDetails> copyTo(String bucketKey, String objectName, String newObjName, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling copyTo");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling copyTo");
        }
        if (newObjName == null) {
            throw new ApiException(400, "Missing the required parameter 'newObjName' when calling copyTo");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/copyto/{newObjName}".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString())).replaceAll("\\{newObjName\\}", this.apiClient.escapeString(newObjName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<PostObjectSigned> createSignedResource(String bucketKey, String objectName, PostBucketsSigned postBucketsSigned, String access, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        PostBucketsSigned localVarPostBody = postBucketsSigned;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling createSignedResource");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling createSignedResource");
        }
        if (postBucketsSigned == null) {
            throw new ApiException(400, "Missing the required parameter 'postBucketsSigned' when calling createSignedResource");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/signed".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access", access));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<PostObjectSigned> localVarReturnType = new GenericType<PostObjectSigned>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> deleteObject(String bucketKey, String objectName, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling deleteObject");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling deleteObject");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<Void> deleteSignedResource(String id, String region, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteSignedResource");
        }
        String localVarPath = "/oss/v2/signedresources/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "region", region));
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<File> getObject(String bucketKey, String objectName, String range, String ifNoneMatch, Date ifModifiedSince, String acceptEncoding, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getObject");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling getObject");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (range != null) {
            localVarHeaderParams.put("Range", this.apiClient.parameterToString(range));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<ObjectFullDetails> getObjectDetails(String bucketKey, String objectName, Date ifModifiedSince, String with, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getObjectDetails");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling getObjectDetails");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/details".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "with", with));
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<ObjectFullDetails> localVarReturnType = new GenericType<ObjectFullDetails>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<BucketObjects> getObjects(String bucketKey, Integer limit, String beginsWith, String startAt, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getObjects");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "beginsWith", beginsWith));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startAt", startAt));
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<BucketObjects> localVarReturnType = new GenericType<BucketObjects>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<File> getSignedResource(String id, String range, String ifNoneMatch, Date ifModifiedSince, String acceptEncoding, String region, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getSignedResource");
        }
        String localVarPath = "/oss/v2/signedresources/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "region", region));
        if (range != null) {
            localVarHeaderParams.put("Range", this.apiClient.parameterToString(range));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.apiClient.parameterToString(ifNoneMatch));
        }
        if (ifModifiedSince != null) {
            localVarHeaderParams.put("If-Modified-Since", this.apiClient.parameterToString(ifModifiedSince));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", this.apiClient.parameterToString(acceptEncoding));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<File> localVarReturnType = new GenericType<File>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<Void> getStatusBySessionId(String bucketKey, String objectName, String sessionId, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        Object localVarPostBody = null;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling getStatusBySessionId");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling getStatusBySessionId");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling getStatusBySessionId");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/status/{sessionId}".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString())).replaceAll("\\{sessionId\\}", this.apiClient.escapeString(sessionId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, null);
    }

    public ApiResponse<ObjectDetails> uploadChunk(String bucketKey, String objectName, Integer contentLength, String contentRange, String sessionId, File body, String contentDisposition, String ifMatch, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        File localVarPostBody = body;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling uploadChunk");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling uploadChunk");
        }
        if (contentLength == null) {
            throw new ApiException(400, "Missing the required parameter 'contentLength' when calling uploadChunk");
        }
        if (contentRange == null) {
            throw new ApiException(400, "Missing the required parameter 'contentRange' when calling uploadChunk");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadChunk");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadChunk");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}/resumable".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentLength != null) {
            localVarHeaderParams.put("Content-Length", this.apiClient.parameterToString(contentLength));
        }
        if (contentRange != null) {
            localVarHeaderParams.put("Content-Range", this.apiClient.parameterToString(contentRange));
        }
        if (contentDisposition != null) {
            localVarHeaderParams.put("Content-Disposition", this.apiClient.parameterToString(contentDisposition));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        if (sessionId != null) {
            localVarHeaderParams.put("Session-Id", this.apiClient.parameterToString(sessionId));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<ObjectDetails> uploadObject(String bucketKey, String objectName, Integer contentLength, File body, String contentDisposition, String ifMatch, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        File localVarPostBody = body;
        if (bucketKey == null) {
            throw new ApiException(400, "Missing the required parameter 'bucketKey' when calling uploadObject");
        }
        if (objectName == null) {
            throw new ApiException(400, "Missing the required parameter 'objectName' when calling uploadObject");
        }
        if (contentLength == null) {
            throw new ApiException(400, "Missing the required parameter 'contentLength' when calling uploadObject");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadObject");
        }
        String localVarPath = "/oss/v2/buckets/{bucketKey}/objects/{objectName}".replaceAll("\\{format\\}", "json").replaceAll("\\{bucketKey\\}", this.apiClient.escapeString(bucketKey.toString())).replaceAll("\\{objectName\\}", this.apiClient.escapeString(objectName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentLength != null) {
            localVarHeaderParams.put("Content-Length", this.apiClient.parameterToString(contentLength));
        }
        if (contentDisposition != null) {
            localVarHeaderParams.put("Content-Disposition", this.apiClient.parameterToString(contentDisposition));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<ObjectDetails> uploadSignedResource(String id, Integer contentLength, File body, String contentDisposition, String xAdsRegion, String ifMatch, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        File localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling uploadSignedResource");
        }
        if (contentLength == null) {
            throw new ApiException(400, "Missing the required parameter 'contentLength' when calling uploadSignedResource");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadSignedResource");
        }
        String localVarPath = "/oss/v2/signedresources/{id}".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentLength != null) {
            localVarHeaderParams.put("Content-Length", this.apiClient.parameterToString(contentLength));
        }
        if (contentDisposition != null) {
            localVarHeaderParams.put("Content-Disposition", this.apiClient.parameterToString(contentDisposition));
        }
        if (xAdsRegion != null) {
            localVarHeaderParams.put("x-ads-region", this.apiClient.parameterToString(xAdsRegion));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("If-Match", this.apiClient.parameterToString(ifMatch));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }

    public ApiResponse<ObjectDetails> uploadSignedResourcesChunk(String id, String contentRange, String sessionId, File body, String contentDisposition, String xAdsRegion, Authentication oauth2, Credentials credentials) throws ApiException, Exception {
        File localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling uploadSignedResourcesChunk");
        }
        if (contentRange == null) {
            throw new ApiException(400, "Missing the required parameter 'contentRange' when calling uploadSignedResourcesChunk");
        }
        if (sessionId == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionId' when calling uploadSignedResourcesChunk");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling uploadSignedResourcesChunk");
        }
        String localVarPath = "/oss/v2/signedresources/{id}/resumable".replaceAll("\\{format\\}", "json").replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (contentRange != null) {
            localVarHeaderParams.put("Content-Range", this.apiClient.parameterToString(contentRange));
        }
        if (contentDisposition != null) {
            localVarHeaderParams.put("Content-Disposition", this.apiClient.parameterToString(contentDisposition));
        }
        if (xAdsRegion != null) {
            localVarHeaderParams.put("x-ads-region", this.apiClient.parameterToString(xAdsRegion));
        }
        if (sessionId != null) {
            localVarHeaderParams.put("Session-Id", this.apiClient.parameterToString(sessionId));
        }
        String[] localVarAccepts = new String[]{"application/vnd.api+json", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/octet-stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        GenericType<ObjectDetails> localVarReturnType = new GenericType<ObjectDetails>(){};
        return this.apiClient.invokeAPI(oauth2, credentials, localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarReturnType);
    }
}

